﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/ens/detail/ens_Log.h>
#include <nn/ens/detail/util/rapidjson/ens_RapidJsonAllocator.h>
#include <nn/result/result_HandlingUtility.h>

#define RAPIDJSON_NO_INT64DEFINE
#define RAPIDJSON_NO_SIZETYPEDEFINE

#define RAPIDJSON_NAMESPACE         nne::rapidjson::ens
#define RAPIDJSON_NAMESPACE_BEGIN   namespace nne { namespace rapidjson { namespace ens {
#define RAPIDJSON_NAMESPACE_END     }}}

#define RAPIDJSON_ASSERT(x) NN_SDK_ASSERT(x)

#define RAPIDJSON_HAS_CXX11_RVALUE_REFS 1 // NOLINT(preprocessor/const)
#define RAPIDJSON_HAS_CXX11_TYPETRAITS  1 // NOLINT(preprocessor/const)

RAPIDJSON_NAMESPACE_BEGIN

// SizeType を size_t で固定する。
typedef std::size_t SizeType;

RAPIDJSON_NAMESPACE_END

#if defined(NN_BUILD_CONFIG_OS_WIN)
#pragma warning(push)
#pragma warning(disable: 4244)
#pragma warning(disable: 4668)
#pragma warning(disable: 4702)
#endif

#include <rapidjson/reader.h>

#if defined(NN_BUILD_CONFIG_OS_WIN)
#pragma warning(pop)
#endif

namespace nn { namespace ens { namespace detail { namespace util { namespace rapidjson {

/**
 * @brief   ライブラリが使用する RapidJSON の JSON リーダー
 *
 * @details
 */
typedef RAPIDJSON_NAMESPACE::GenericReader<RAPIDJSON_NAMESPACE::UTF8<>, RAPIDJSON_NAMESPACE::UTF8<>, NullAllocator> Reader;

}}}}}
