﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <curl/curl.h>

namespace nn { namespace ens { namespace detail { namespace util {

/**
 * @brief   HTTP 通信の結果を nn::Result に変換します。
 *
 * @param[in]   code    CURLcode
 *
 * @return  nn::Result 値
 *
 * @details
 */
nn::Result HandleHttpError(CURLcode code) NN_NOEXCEPT;

/**
 * @brief   HTTP ステータスコードを nn::Result に変換します。
 *
 * @param[in]   statusCode  ステータスコード
 *
 * @return  nn::Result 値
 *
 * @details
 */
nn::Result HandleHttpStatusCode(long statusCode) NN_NOEXCEPT;

}}}}
