﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace ens { namespace detail { namespace util {

/**
 * @brief   イベントを保持するクラス
 *
 * @details
 *  イベントを侵入型リストで連結可能にします。
 */
class EventHolder : public nn::util::IntrusiveListBaseNode<EventHolder>
{
private:
    NN_DISALLOW_COPY(EventHolder);
    NN_DISALLOW_MOVE(EventHolder);

public:
    /**
     * @brief   コンストラクタ
     *
     * @param[in]   clearMode   イベントのクリアモード
     *
     * @details
     */
    explicit EventHolder(nn::os::EventClearMode clearMode) NN_NOEXCEPT
        : m_Event(clearMode)
    {
    }

    /**
     * @brief   イベントを取得します。
     *
     * @return  イベント
     *
     * @details
     */
    nn::os::Event& Get() NN_NOEXCEPT
    {
        return m_Event;
    }

private:
    //
    nn::os::Event m_Event;
};

}}}}
