﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_HttpTask.h>

namespace nn { namespace ens { namespace detail { namespace core { namespace task {

/**
 * @brief   認証トークン取得の非同期処理実装タスク
 *
 * @details
 */
class TaskGetAuthToken : public detail::core::HttpTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskGetAuthToken() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskGetAuthToken() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[out]  pOutAuthToken   認証トークン
     * @param[in]   credential      認証情報
     *
     * @details
     */
    void SetParameter(AuthToken* pOutAuthToken, const Credential& credential) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    AuthToken* m_pOutAuthToken;
    //
    Credential m_Credential;

private:
    //
    nn::Result StepGet() NN_NOEXCEPT;
};

}}}}}
