﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <curl/curl.h>

namespace nn { namespace ens { namespace detail { namespace core {

/**
 * @brief   HTTP リクエストヘッダ（curl_slist オブジェクト）を管理するクラス
 *
 * @details
 */
class HttpRequestHeader
{
public:
    /**
     * @brief   HTTP リクエストヘッダのフィールドの最大サイズです。
     *
     * @details
     */
    static const size_t FieldSize = 4096;

public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    HttpRequestHeader() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~HttpRequestHeader() NN_NOEXCEPT;

    /**
     * @brief   クリアします。
     *
     * @details
     */
    void Clear() NN_NOEXCEPT;

    /**
     * @brief   curl_slist オブジェクトを取得します。
     *
     * @return  curl_slist オブジェクト
     *
     * @details
     */
    curl_slist* Get() NN_NOEXCEPT;

    /**
     * @brief   HTTP リクエストヘッダを追加します。
     *
     * @param[in]   pName   フィールド名
     * @param[in]   pValue  フィールド値
     * @param[in]   ...     フィールド値の可変長パラメータ
     *
     * @return  処理結果
     *
     * @pre
     *  - pName != nullptr
     *  - pValue != nullptr
     *  - nn::util::Strnlen(pName, INT_MAX) > 0
     *
     * @details
     *  本関数は FieldSize バイトのバッファをスタック上に確保します。
     */
    nn::Result Add(const char* pName, const char* pValue, ...) NN_NOEXCEPT;

private:
    //
    curl_slist* m_pHeaderList;
};

}}}}
