﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>
#include <nn/ens/ens_TypesForAcbaa.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

/**
 * @brief   SendMessage の非同期処理実装タスク
 *
 * @details
 */
class TaskSendMessage : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskSendMessage() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskSendMessage() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[in]   targetUserId    送信先のユーザー ID
     * @param[in]   metadata        メタデータ
     * @param[in]   body            ボディ
     *
     * @details
     */
    void SetParameter(const UserId& targetUserId, const SendBuffer& metadata, const SendBuffer& body) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    UserId m_TargetUserId;
    //
    SendBuffer m_Metadata;
    SendBuffer m_Body;

private:
    //
    nn::Result StepSend() NN_NOEXCEPT;
};

}}}}}
