﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/applet/applet.h>
#include <nn/applet/applet_Types.h>
#include <nn/capsrv/capsrv_AlbumCacheData.h>
#include <nn/capsrv/capsrv_AlbumEntry.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>
#include <nn/capsrv/capsrv_AlbumFileDateTime.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/capsrv/capsrv_AlbumMovieReadStreamHandle.h>
#include <nn/capsrv/capsrv_AlbumMovieWriteStreamHandle.h>
#include <nn/capsrv/capsrv_AlbumStorage.h>
#include <nn/capsrv/capsrv_AlbumUsage.h>
#include <nn/capsrv/capsrv_AppletData.h>
#include <nn/capsrv/capsrv_ApplicationAlbumEntry.h>
#include <nn/capsrv/capsrv_ApplicationAlbumFileEntry.h>
#include <nn/capsrv/capsrv_ApplicationData.h>
#include <nn/capsrv/capsrv_OverlayNotificationRequest.h>
#include <nn/capsrv/capsrv_ScreenShotAttribute.h>
#include <nn/capsrv/capsrv_ScreenShotDecodeOption.h>
#include <nn/capsrv/capsrv_ScreenShotSize.h>
#include <nn/capsrv/capsrv_SystemReservedInfo.h>
#include <nn/capsrv/sf/capsrv_ServiceType.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/sf/sf_Types.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

class IAlbumAccessorApplicationSession;

class IAlbumAccessorService;

class IAlbumAccessorSession;

class IAlbumApplicationService;

class IAlbumControlService;

class IAlbumControlSession;

class IDecoderControlService;

class IMovieReadStreamServiceObject;

class IMovieWriteStreamServiceObject;

class IScreenShotApplicationService;

class IScreenShotControlService;

class IScreenShotService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAlbumAccessorApplicationSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAlbumAccessorApplicationSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAlbumAccessorApplicationSession)

        ::nn::Result OpenAlbumMovieReadStream(::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (outHandle, entry, aruid));
        }

        ::nn::Result CloseAlbumMovieReadStream(::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (handle));
        }

        ::nn::Result GetAlbumMovieReadStreamMovieDataSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (outSize, handle));
        }

        ::nn::Result ReadMovieDataFromAlbumMovieReadStream(::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (outReadSize, outBuffer, handle, offset));
        }

        ::nn::Result GetAlbumMovieReadStreamBrokenReason(::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAlbumAccessorApplicationSession
    {
    public:
        nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IAlbumAccessorApplicationSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAlbumMovieReadStream, (outHandle, entry, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseAlbumMovieReadStream, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (outSize, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (outReadSize, outBuffer, handle, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IAlbumAccessorApplicationSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IAlbumAccessorApplicationSession))

    // nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (entry, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAlbumMovieReadStream)

    // nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseAlbumMovieReadStream)

    // nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieReadStreamMovieDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieReadStreamMovieDataSize)

    // nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadMovieDataFromAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReadSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outReadSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadMovieDataFromAlbumMovieReadStream)

    // nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieReadStreamBrokenReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieReadStreamBrokenReason)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumFileEntry), 48, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IAlbumAccessorApplicationSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IAlbumAccessorApplicationSession))

    // nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAlbumMovieReadStream)
    }

    // nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseAlbumMovieReadStream)
    }

    // nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieReadStreamMovieDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieReadStreamMovieDataSize)
    }

    // nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadMovieDataFromAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadMovieDataFromAlbumMovieReadStream)
    }

    // nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieReadStreamBrokenReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieReadStreamBrokenReason)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IAlbumAccessorApplicationSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IAlbumAccessorApplicationSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieReadStreamMovieDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieReadStreamMovieDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadMovieDataFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadMovieDataFromAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReadSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieReadStreamBrokenReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieReadStreamBrokenReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieReadStreamMovieDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadMovieDataFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieReadStreamBrokenReason)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IAlbumAccessorApplicationSession))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAlbumAccessorService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAlbumAccessorService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileList, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumFile, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFile, (const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StorageCopyAlbumFile, (const ::nn::capsrv::AlbumFileId& sourceFileId, ::nn::capsrv::AlbumStorageType destinationStorage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAlbumMounted, (::nn::sf::Out<bool> outValue, ::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage2> outValue, ::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileSize, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumFileThumbnail, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImage, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImage, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntry, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx0, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage3, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage3> outValue, ::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMountResult, (::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage16, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage16> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileCountEx0, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOverlayScreenShotThumbnail, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOverlayMovieThumbnail, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAutoSavingStorage, (::nn::sf::Out<::nn::capsrv::AlbumStorageType> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredStorageSpaceSizeToCopyAll, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::capsrv::AlbumStorageType dstStorage, ::nn::capsrv::AlbumStorageType srcStorage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx0, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx1, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx1, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ForceAlbumUnmounted, (::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetAlbumMountStatus, (::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RefreshAlbumCache, (::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumCache, (::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumCacheEx, (::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsType contents))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntryAruid, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetInternalErrorConversionEnabled, (bool value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadMakerNoteInfoForDebug, (::nn::sf::Out<::std::uint64_t> outFileSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessorSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorSession>> outValue, ::nn::applet::AppletResourceUserId aruid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAlbumAccessorService)

        ::nn::Result GetAlbumFileCount(::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileCount, (outCount, storage));
        }

        ::nn::Result GetAlbumFileList(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileList, (outCount, pOutList, storage));
        }

        ::nn::Result LoadAlbumFile(::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumFile, (outSize, outBuffer, fileId));
        }

        ::nn::Result DeleteAlbumFile(const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteAlbumFile, (fileId));
        }

        ::nn::Result StorageCopyAlbumFile(const ::nn::capsrv::AlbumFileId& sourceFileId, ::nn::capsrv::AlbumStorageType destinationStorage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StorageCopyAlbumFile, (sourceFileId, destinationStorage));
        }

        ::nn::Result IsAlbumMounted(::nn::sf::Out<bool> outValue, ::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAlbumMounted, (outValue, storage));
        }

        ::nn::Result GetAlbumUsage(::nn::sf::Out<::nn::capsrv::detail::AlbumUsage2> outValue, ::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumUsage, (outValue, storage));
        }

        ::nn::Result GetAlbumFileSize(::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileSize, (outSize, fileId));
        }

        ::nn::Result LoadAlbumFileThumbnail(::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumFileThumbnail, (outSize, outBuffer, fileId));
        }

        ::nn::Result LoadAlbumScreenShotImage(::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImage, (outWidth, outHeight, outBuffer, fileId, workBuffer));
        }

        ::nn::Result LoadAlbumScreenShotThumbnailImage(::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImage, (outWidth, outHeight, outBuffer, fileId, workBuffer));
        }

        ::nn::Result GetAlbumEntryFromApplicationAlbumEntry(::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntry, (outEntry, srcEntry, applicationId));
        }

        ::nn::Result LoadAlbumScreenShotImageEx(::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx, (outWidth, outHeight, outBuffer, fileId, option, workBuffer));
        }

        ::nn::Result LoadAlbumScreenShotThumbnailImageEx(::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx, (outWidth, outHeight, outBuffer, fileId, option, workBuffer));
        }

        ::nn::Result LoadAlbumScreenShotImageEx0(::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx0, (outWidth, outHeight, outAttribute, outBuffer, fileId, option, workBuffer));
        }

        ::nn::Result GetAlbumUsage3(::nn::sf::Out<::nn::capsrv::detail::AlbumUsage3> outValue, ::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumUsage3, (outValue, storage));
        }

        ::nn::Result GetAlbumMountResult(::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMountResult, (storage));
        }

        ::nn::Result GetAlbumUsage16(::nn::sf::Out<::nn::capsrv::detail::AlbumUsage16> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumUsage16, (outValue, storage, contentsMask));
        }

        ::nn::Result GetAlbumFileCountEx0(::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileCountEx0, (outCount, storage, contentsMask));
        }

        ::nn::Result GetAlbumFileListEx0(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0, (outCount, pOutList, storage, contentsMask));
        }

        ::nn::Result GetLastOverlayScreenShotThumbnail(::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLastOverlayScreenShotThumbnail, (outFileId, outSize, outBuffer));
        }

        ::nn::Result GetLastOverlayMovieThumbnail(::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLastOverlayMovieThumbnail, (outFileId, outSize, outBuffer));
        }

        ::nn::Result GetAutoSavingStorage(::nn::sf::Out<::nn::capsrv::AlbumStorageType> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAutoSavingStorage, (outValue));
        }

        ::nn::Result GetRequiredStorageSpaceSizeToCopyAll(::nn::sf::Out<::std::uint64_t> outSize, ::nn::capsrv::AlbumStorageType dstStorage, ::nn::capsrv::AlbumStorageType srcStorage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequiredStorageSpaceSizeToCopyAll, (outSize, dstStorage, srcStorage));
        }

        ::nn::Result LoadAlbumScreenShotThumbnailImageEx0(::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx0, (outWidth, outHeight, outAttribute, outBuffer, fileId, option, workBuffer));
        }

        ::nn::Result LoadAlbumScreenShotImageEx1(::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx1, (output, outBuffer, fileId, option, workBuffer));
        }

        ::nn::Result LoadAlbumScreenShotThumbnailImageEx1(::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx1, (output, outBuffer, fileId, option, workBuffer));
        }

        ::nn::Result ForceAlbumUnmounted(::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ForceAlbumUnmounted, (storage));
        }

        ::nn::Result ResetAlbumMountStatus(::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetAlbumMountStatus, (storage));
        }

        ::nn::Result RefreshAlbumCache(::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RefreshAlbumCache, (storage));
        }

        ::nn::Result GetAlbumCache(::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumCache, (outValue, storage));
        }

        ::nn::Result GetAlbumCacheEx(::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsType contents) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumCacheEx, (outValue, storage, contents));
        }

        ::nn::Result GetAlbumEntryFromApplicationAlbumEntryAruid(::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntryAruid, (outEntry, srcEntry, aruid));
        }

        ::nn::Result SetInternalErrorConversionEnabled(bool value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetInternalErrorConversionEnabled, (value));
        }

        ::nn::Result LoadMakerNoteInfoForDebug(::nn::sf::Out<::std::uint64_t> outFileSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadMakerNoteInfoForDebug, (outFileSize, outBuffer, fileId, workBuffer));
        }

        ::nn::Result OpenAccessorSession(::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorSession>> outValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAccessorSession, (outValue, aruid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAlbumAccessorService
    {
    public:
        nn::Result GetAlbumFileCount(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumFileList(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result LoadAlbumFile(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result DeleteAlbumFile(const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result StorageCopyAlbumFile(const nn::capsrv::AlbumFileId& sourceFileId, nn::capsrv::AlbumStorageType destinationStorage) NN_NOEXCEPT;
        nn::Result IsAlbumMounted(nn::sf::Out<bool> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumUsage(nn::sf::Out<nn::capsrv::detail::AlbumUsage2> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumFileSize(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result LoadAlbumFileThumbnail(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result GetAlbumEntryFromApplicationAlbumEntry(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result GetAlbumUsage3(nn::sf::Out<nn::capsrv::detail::AlbumUsage3> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumMountResult(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumUsage16(nn::sf::Out<nn::capsrv::detail::AlbumUsage16> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;
        nn::Result GetAlbumFileCountEx0(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;
        nn::Result GetAlbumFileListEx0(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;
        nn::Result GetLastOverlayScreenShotThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result GetLastOverlayMovieThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result GetAutoSavingStorage(nn::sf::Out<nn::capsrv::AlbumStorageType> outValue) NN_NOEXCEPT;
        nn::Result GetRequiredStorageSpaceSizeToCopyAll(nn::sf::Out<std::uint64_t> outSize, nn::capsrv::AlbumStorageType dstStorage, nn::capsrv::AlbumStorageType srcStorage) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result ForceAlbumUnmounted(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result ResetAlbumMountStatus(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result RefreshAlbumCache(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumCache(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumCacheEx(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsType contents) NN_NOEXCEPT;
        nn::Result GetAlbumEntryFromApplicationAlbumEntryAruid(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result SetInternalErrorConversionEnabled(bool value) NN_NOEXCEPT;
        nn::Result LoadMakerNoteInfoForDebug(nn::sf::Out<std::uint64_t> outFileSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result OpenAccessorSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetAlbumFileCount(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumFileList(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result LoadAlbumFile(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result DeleteAlbumFile(const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result StorageCopyAlbumFile(const nn::capsrv::AlbumFileId& sourceFileId, nn::capsrv::AlbumStorageType destinationStorage) NN_NOEXCEPT;
    nn::Result IsAlbumMounted(nn::sf::Out<bool> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumUsage(nn::sf::Out<nn::capsrv::detail::AlbumUsage2> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumFileSize(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result LoadAlbumFileThumbnail(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotThumbnailImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result GetAlbumEntryFromApplicationAlbumEntry(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotThumbnailImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result GetAlbumUsage3(nn::sf::Out<nn::capsrv::detail::AlbumUsage3> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumMountResult(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumUsage16(nn::sf::Out<nn::capsrv::detail::AlbumUsage16> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;
    nn::Result GetAlbumFileCountEx0(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;
    nn::Result GetAlbumFileListEx0(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;
    nn::Result GetLastOverlayScreenShotThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result GetLastOverlayMovieThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result GetAutoSavingStorage(nn::sf::Out<nn::capsrv::AlbumStorageType> outValue) NN_NOEXCEPT;
    nn::Result GetRequiredStorageSpaceSizeToCopyAll(nn::sf::Out<std::uint64_t> outSize, nn::capsrv::AlbumStorageType dstStorage, nn::capsrv::AlbumStorageType srcStorage) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotThumbnailImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotThumbnailImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result ForceAlbumUnmounted(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result ResetAlbumMountStatus(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result RefreshAlbumCache(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumCache(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result GetAlbumCacheEx(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsType contents) NN_NOEXCEPT;
    nn::Result GetAlbumEntryFromApplicationAlbumEntryAruid(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result SetInternalErrorConversionEnabled(bool value) NN_NOEXCEPT;
    nn::Result LoadMakerNoteInfoForDebug(nn::sf::Out<std::uint64_t> outFileSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
    nn::Result OpenAccessorSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IAlbumAccessorService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileCount, (outCount, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileList, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileList, (outCount, pOutList, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumFile, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumFile, (outSize, outBuffer, fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFile, (const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteAlbumFile, (fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StorageCopyAlbumFile, (const ::nn::capsrv::AlbumFileId& sourceFileId, ::nn::capsrv::AlbumStorageType destinationStorage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StorageCopyAlbumFile, (sourceFileId, destinationStorage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAlbumMounted, (::nn::sf::Out<bool> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAlbumMounted, (outValue, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage2> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumUsage, (outValue, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileSize, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileSize, (outSize, fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumFileThumbnail, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumFileThumbnail, (outSize, outBuffer, fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImage, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotImage, (outWidth, outHeight, outBuffer, fileId, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImage, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImage, (outWidth, outHeight, outBuffer, fileId, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntry, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntry, (outEntry, srcEntry, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotImageEx, (outWidth, outHeight, outBuffer, fileId, option, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx, (outWidth, outHeight, outBuffer, fileId, option, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx0, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotImageEx0, (outWidth, outHeight, outAttribute, outBuffer, fileId, option, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage3, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage3> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumUsage3, (outValue, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMountResult, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMountResult, (storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage16, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage16> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumUsage16, (outValue, storage, contentsMask));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileCountEx0, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileCountEx0, (outCount, storage, contentsMask));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileListEx0, (outCount, pOutList, storage, contentsMask));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOverlayScreenShotThumbnail, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLastOverlayScreenShotThumbnail, (outFileId, outSize, outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOverlayMovieThumbnail, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLastOverlayMovieThumbnail, (outFileId, outSize, outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAutoSavingStorage, (::nn::sf::Out<::nn::capsrv::AlbumStorageType> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAutoSavingStorage, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredStorageSpaceSizeToCopyAll, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::capsrv::AlbumStorageType dstStorage, ::nn::capsrv::AlbumStorageType srcStorage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequiredStorageSpaceSizeToCopyAll, (outSize, dstStorage, srcStorage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx0, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx0, (outWidth, outHeight, outAttribute, outBuffer, fileId, option, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx1, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotImageEx1, (output, outBuffer, fileId, option, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx1, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx1, (output, outBuffer, fileId, option, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ForceAlbumUnmounted, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ForceAlbumUnmounted, (storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetAlbumMountStatus, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetAlbumMountStatus, (storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshAlbumCache, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RefreshAlbumCache, (storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumCache, (::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumCache, (outValue, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumCacheEx, (::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsType contents))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumCacheEx, (outValue, storage, contents));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntryAruid, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntryAruid, (outEntry, srcEntry, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInternalErrorConversionEnabled, (bool value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetInternalErrorConversionEnabled, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadMakerNoteInfoForDebug, (::nn::sf::Out<::std::uint64_t> outFileSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadMakerNoteInfoForDebug, (outFileSize, outBuffer, fileId, workBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessorSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorSession>> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAccessorSession, (outValue, aruid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IAlbumAccessorService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IAlbumAccessorService))

    // nn::Result GetAlbumFileCount(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileCount)

    // nn::Result GetAlbumFileList(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutList, 0, (const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileList)

    // nn::Result LoadAlbumFile(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumFile)

    // nn::Result DeleteAlbumFile(const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAlbumFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAlbumFile)

    // nn::Result StorageCopyAlbumFile(const nn::capsrv::AlbumFileId& sourceFileId, nn::capsrv::AlbumStorageType destinationStorage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StorageCopyAlbumFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(destinationStorage, (::nn::capsrv::AlbumStorageType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sourceFileId, (::nn::capsrv::AlbumFileId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (destinationStorage, sourceFileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sourceFileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(destinationStorage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StorageCopyAlbumFile)

    // nn::Result IsAlbumMounted(nn::sf::Out<bool> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAlbumMounted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAlbumMounted)

    // nn::Result GetAlbumUsage(nn::sf::Out<nn::capsrv::detail::AlbumUsage2> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumUsage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::capsrv::detail::AlbumUsage2), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumUsage)

    // nn::Result GetAlbumFileSize(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileSize)

    // nn::Result LoadAlbumFileThumbnail(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumFileThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumFileThumbnail)

    // nn::Result LoadAlbumScreenShotImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotImage)

    // nn::Result LoadAlbumScreenShotThumbnailImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotThumbnailImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotThumbnailImage)

    // nn::Result GetAlbumEntryFromApplicationAlbumEntry(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumEntryFromApplicationAlbumEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (srcEntry, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::AlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumEntryFromApplicationAlbumEntry)

    // nn::Result LoadAlbumScreenShotImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotImageEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (fileId, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotImageEx)

    // nn::Result LoadAlbumScreenShotThumbnailImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotThumbnailImageEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (fileId, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotThumbnailImageEx)

    // nn::Result LoadAlbumScreenShotImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotImageEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (fileId, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAttribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::uint64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::uint64_t), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outAttribute, outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAttribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotImageEx0)

    // nn::Result GetAlbumUsage3(nn::sf::Out<nn::capsrv::detail::AlbumUsage3> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumUsage3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::capsrv::detail::AlbumUsage3), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumUsage3)

    // nn::Result GetAlbumMountResult(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMountResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMountResult)

    // nn::Result GetAlbumUsage16(nn::sf::Out<nn::capsrv::detail::AlbumUsage16> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumUsage16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage16>), 384, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentsMask, (::nn::capsrv::AlbumFileContentsFlag), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, contentsMask))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentsMask)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumUsage16)

    // nn::Result GetAlbumFileCountEx0(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileCountEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentsMask, (::nn::capsrv::AlbumFileContentsFlag), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, contentsMask))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentsMask)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileCountEx0)

    // nn::Result GetAlbumFileListEx0(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileListEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutList, 0, (const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentsMask, (::nn::capsrv::AlbumFileContentsFlag), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, contentsMask))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentsMask)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileListEx0)

    // nn::Result GetLastOverlayScreenShotThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastOverlayScreenShotThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outFileId, outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastOverlayScreenShotThumbnail)

    // nn::Result GetLastOverlayMovieThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastOverlayMovieThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outFileId, outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastOverlayMovieThumbnail)

    // nn::Result GetAutoSavingStorage(nn::sf::Out<nn::capsrv::AlbumStorageType> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAutoSavingStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAutoSavingStorage)

    // nn::Result GetRequiredStorageSpaceSizeToCopyAll(nn::sf::Out<std::uint64_t> outSize, nn::capsrv::AlbumStorageType dstStorage, nn::capsrv::AlbumStorageType srcStorage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequiredStorageSpaceSizeToCopyAll)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstStorage, (::nn::capsrv::AlbumStorageType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcStorage, (::nn::capsrv::AlbumStorageType), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (dstStorage, srcStorage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstStorage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcStorage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequiredStorageSpaceSizeToCopyAll)

    // nn::Result LoadAlbumScreenShotThumbnailImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotThumbnailImageEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (fileId, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAttribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::uint64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::uint64_t), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outAttribute, outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAttribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotThumbnailImageEx0)

    // nn::Result LoadAlbumScreenShotImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotImageEx1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(output, 0, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1>), 1104, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (output, outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (fileId, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotImageEx1)

    // nn::Result LoadAlbumScreenShotThumbnailImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotThumbnailImageEx1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(output, 0, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1>), 1104, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (output, outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (fileId, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotThumbnailImageEx1)

    // nn::Result ForceAlbumUnmounted(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ForceAlbumUnmounted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ForceAlbumUnmounted)

    // nn::Result ResetAlbumMountStatus(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetAlbumMountStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetAlbumMountStatus)

    // nn::Result RefreshAlbumCache(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RefreshAlbumCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RefreshAlbumCache)

    // nn::Result GetAlbumCache(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8012)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::capsrv::AlbumCacheData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumCache)

    // nn::Result GetAlbumCacheEx(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsType contents) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumCacheEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8013)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contents, (::nn::capsrv::AlbumFileContentsType), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, contents))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::capsrv::AlbumCacheData), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contents)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumCacheEx)

    // nn::Result GetAlbumEntryFromApplicationAlbumEntryAruid(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumEntryFromApplicationAlbumEntryAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8021)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (srcEntry, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::AlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumEntryFromApplicationAlbumEntryAruid)

    // nn::Result SetInternalErrorConversionEnabled(bool value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetInternalErrorConversionEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetInternalErrorConversionEnabled)

    // nn::Result LoadMakerNoteInfoForDebug(nn::sf::Out<std::uint64_t> outFileSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadMakerNoteInfoForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFileSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadMakerNoteInfoForDebug)

    // nn::Result OpenAccessorSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAccessorSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAccessorSession)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumStorageType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumUsage2), 48, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ScreenShotDecodeOption), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumUsage3), 72, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumUsage16), 384, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileContentsFlag), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1), 1104, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumCacheData), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileContentsType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IAlbumAccessorService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IAlbumAccessorService))

    // nn::Result GetAlbumFileCount(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileCount, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileCount)
    }

    // nn::Result GetAlbumFileList(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileList, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileList)
    }

    // nn::Result LoadAlbumFile(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumFile, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumFile)
    }

    // nn::Result DeleteAlbumFile(const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFile, (const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAlbumFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAlbumFile)
    }

    // nn::Result StorageCopyAlbumFile(const nn::capsrv::AlbumFileId& sourceFileId, nn::capsrv::AlbumStorageType destinationStorage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StorageCopyAlbumFile, (const ::nn::capsrv::AlbumFileId& sourceFileId, ::nn::capsrv::AlbumStorageType destinationStorage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StorageCopyAlbumFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sourceFileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(destinationStorage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StorageCopyAlbumFile)
    }

    // nn::Result IsAlbumMounted(nn::sf::Out<bool> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAlbumMounted, (::nn::sf::Out<bool> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAlbumMounted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAlbumMounted)
    }

    // nn::Result GetAlbumUsage(nn::sf::Out<nn::capsrv::detail::AlbumUsage2> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage2> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumUsage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumUsage)
    }

    // nn::Result GetAlbumFileSize(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileSize, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileSize)
    }

    // nn::Result LoadAlbumFileThumbnail(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumFileThumbnail, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumFileThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumFileThumbnail)
    }

    // nn::Result LoadAlbumScreenShotImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImage, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotImage)
    }

    // nn::Result LoadAlbumScreenShotThumbnailImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImage, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotThumbnailImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotThumbnailImage)
    }

    // nn::Result GetAlbumEntryFromApplicationAlbumEntry(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntry, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumEntryFromApplicationAlbumEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumEntryFromApplicationAlbumEntry)
    }

    // nn::Result LoadAlbumScreenShotImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotImageEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotImageEx)
    }

    // nn::Result LoadAlbumScreenShotThumbnailImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotThumbnailImageEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotThumbnailImageEx)
    }

    // nn::Result LoadAlbumScreenShotImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx0, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotImageEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAttribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotImageEx0)
    }

    // nn::Result GetAlbumUsage3(nn::sf::Out<nn::capsrv::detail::AlbumUsage3> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage3, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage3> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumUsage3)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumUsage3)
    }

    // nn::Result GetAlbumMountResult(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMountResult, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMountResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMountResult)
    }

    // nn::Result GetAlbumUsage16(nn::sf::Out<nn::capsrv::detail::AlbumUsage16> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumUsage16, (::nn::sf::Out<::nn::capsrv::detail::AlbumUsage16> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumUsage16)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentsMask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumUsage16)
    }

    // nn::Result GetAlbumFileCountEx0(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileCountEx0, (::nn::sf::Out<::std::uint64_t> outCount, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileCountEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentsMask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileCountEx0)
    }

    // nn::Result GetAlbumFileListEx0(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::AlbumEntry>& pOutList, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsFlag contentsMask))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileListEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentsMask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileListEx0)
    }

    // nn::Result GetLastOverlayScreenShotThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOverlayScreenShotThumbnail, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastOverlayScreenShotThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastOverlayScreenShotThumbnail)
    }

    // nn::Result GetLastOverlayMovieThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastOverlayMovieThumbnail, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::sf::Out<::std::uint64_t> outSize, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastOverlayMovieThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastOverlayMovieThumbnail)
    }

    // nn::Result GetAutoSavingStorage(nn::sf::Out<nn::capsrv::AlbumStorageType> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAutoSavingStorage, (::nn::sf::Out<::nn::capsrv::AlbumStorageType> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAutoSavingStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAutoSavingStorage)
    }

    // nn::Result GetRequiredStorageSpaceSizeToCopyAll(nn::sf::Out<std::uint64_t> outSize, nn::capsrv::AlbumStorageType dstStorage, nn::capsrv::AlbumStorageType srcStorage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequiredStorageSpaceSizeToCopyAll, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::capsrv::AlbumStorageType dstStorage, ::nn::capsrv::AlbumStorageType srcStorage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequiredStorageSpaceSizeToCopyAll)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcStorage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequiredStorageSpaceSizeToCopyAll)
    }

    // nn::Result LoadAlbumScreenShotThumbnailImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx0, (::nn::sf::Out<::std::uint64_t> outWidth, ::nn::sf::Out<::std::uint64_t> outHeight, ::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotThumbnailImageEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAttribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotThumbnailImageEx0)
    }

    // nn::Result LoadAlbumScreenShotImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageEx1, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotImageEx1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotImageEx1)
    }

    // nn::Result LoadAlbumScreenShotThumbnailImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageEx1, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotThumbnailImageEx1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotThumbnailImageEx1)
    }

    // nn::Result ForceAlbumUnmounted(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ForceAlbumUnmounted, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ForceAlbumUnmounted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ForceAlbumUnmounted)
    }

    // nn::Result ResetAlbumMountStatus(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetAlbumMountStatus, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetAlbumMountStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetAlbumMountStatus)
    }

    // nn::Result RefreshAlbumCache(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RefreshAlbumCache, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RefreshAlbumCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RefreshAlbumCache)
    }

    // nn::Result GetAlbumCache(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumCache, (::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumCache)
    }

    // nn::Result GetAlbumCacheEx(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsType contents) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumCacheEx, (::nn::sf::Out<::nn::capsrv::AlbumCacheData> outValue, ::nn::capsrv::AlbumStorageType storage, ::nn::capsrv::AlbumFileContentsType contents))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumCacheEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contents)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumCacheEx)
    }

    // nn::Result GetAlbumEntryFromApplicationAlbumEntryAruid(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumEntryFromApplicationAlbumEntryAruid, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outEntry, const ::nn::capsrv::ApplicationAlbumEntry& srcEntry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumEntryFromApplicationAlbumEntryAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumEntryFromApplicationAlbumEntryAruid)
    }

    // nn::Result SetInternalErrorConversionEnabled(bool value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetInternalErrorConversionEnabled, (bool value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetInternalErrorConversionEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetInternalErrorConversionEnabled)
    }

    // nn::Result LoadMakerNoteInfoForDebug(nn::sf::Out<std::uint64_t> outFileSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadMakerNoteInfoForDebug, (::nn::sf::Out<::std::uint64_t> outFileSize, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::OutBuffer& workBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadMakerNoteInfoForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadMakerNoteInfoForDebug)
    }

    // nn::Result OpenAccessorSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessorSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorSession>> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAccessorSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAccessorSession)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IAlbumAccessorService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IAlbumAccessorService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAlbumFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAlbumFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StorageCopyAlbumFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StorageCopyAlbumFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sourceFileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(destinationStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAlbumMounted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAlbumMounted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumUsage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumUsage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumFileThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumFileThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotThumbnailImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotThumbnailImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumEntryFromApplicationAlbumEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumEntryFromApplicationAlbumEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotImageEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotImageEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotThumbnailImageEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotThumbnailImageEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotImageEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotImageEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAttribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumUsage3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumUsage3)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMountResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMountResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumUsage16)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumUsage16)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentsMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileCountEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileCountEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentsMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileListEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileListEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentsMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastOverlayScreenShotThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastOverlayScreenShotThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastOverlayMovieThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastOverlayMovieThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAutoSavingStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAutoSavingStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequiredStorageSpaceSizeToCopyAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequiredStorageSpaceSizeToCopyAll)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstStorage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotThumbnailImageEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotThumbnailImageEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAttribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotImageEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotImageEx1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotThumbnailImageEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotThumbnailImageEx1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ForceAlbumUnmounted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ForceAlbumUnmounted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetAlbumMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetAlbumMountStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RefreshAlbumCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RefreshAlbumCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumCacheEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumCacheEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contents)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumEntryFromApplicationAlbumEntryAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumEntryFromApplicationAlbumEntryAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetInternalErrorConversionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetInternalErrorConversionEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadMakerNoteInfoForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadMakerNoteInfoForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAccessorSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorSession>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAccessorSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAlbumFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StorageCopyAlbumFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAlbumMounted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumUsage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumFileThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotThumbnailImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumEntryFromApplicationAlbumEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotImageEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotThumbnailImageEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotImageEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumUsage3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMountResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumUsage16)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileCountEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileListEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastOverlayScreenShotThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastOverlayMovieThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAutoSavingStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequiredStorageSpaceSizeToCopyAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotThumbnailImageEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotImageEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotThumbnailImageEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ForceAlbumUnmounted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetAlbumMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RefreshAlbumCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumCacheEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumEntryFromApplicationAlbumEntryAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetInternalErrorConversionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadMakerNoteInfoForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAccessorSession)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IAlbumAccessorService))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMovieReadStreamServiceObject, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMovieReadStreamServiceObject)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamImageDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadImageDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadFileAttributeFromAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMovieReadStreamServiceObject)

        ::nn::Result OpenAlbumMovieReadStream(::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (outHandle, fileId));
        }

        ::nn::Result CloseAlbumMovieReadStream(::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (handle));
        }

        ::nn::Result GetAlbumMovieReadStreamMovieDataSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (outSize, handle));
        }

        ::nn::Result ReadMovieDataFromAlbumMovieReadStream(::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (outReadSize, outBuffer, handle, offset));
        }

        ::nn::Result GetAlbumMovieReadStreamBrokenReason(::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (handle));
        }

        ::nn::Result GetAlbumMovieReadStreamImageDataSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamImageDataSize, (outSize, handle));
        }

        ::nn::Result ReadImageDataFromAlbumMovieReadStream(::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadImageDataFromAlbumMovieReadStream, (outReadSize, outBuffer, handle, offset));
        }

        ::nn::Result ReadFileAttributeFromAlbumMovieReadStream(::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadFileAttributeFromAlbumMovieReadStream, (outAttribute, handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMovieReadStreamServiceObject
    {
    public:
        nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAlbumMovieReadStream, (outHandle, fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CloseAlbumMovieReadStream, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (outSize, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (outReadSize, outBuffer, handle, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamImageDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieReadStreamImageDataSize, (outSize, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadImageDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadImageDataFromAlbumMovieReadStream, (outReadSize, outBuffer, handle, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadFileAttributeFromAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadFileAttributeFromAlbumMovieReadStream, (outAttribute, handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IMovieReadStreamServiceObject>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IMovieReadStreamServiceObject))

    // nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAlbumMovieReadStream)

    // nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseAlbumMovieReadStream)

    // nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieReadStreamMovieDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieReadStreamMovieDataSize)

    // nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadMovieDataFromAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReadSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outReadSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadMovieDataFromAlbumMovieReadStream)

    // nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieReadStreamBrokenReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieReadStreamBrokenReason)

    // nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieReadStreamImageDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieReadStreamImageDataSize)

    // nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadImageDataFromAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReadSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outReadSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadImageDataFromAlbumMovieReadStream)

    // nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadFileAttributeFromAlbumMovieReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outAttribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outAttribute))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAttribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadFileAttributeFromAlbumMovieReadStream)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IMovieReadStreamServiceObject, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IMovieReadStreamServiceObject))

    // nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAlbumMovieReadStream)
    }

    // nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CloseAlbumMovieReadStream, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseAlbumMovieReadStream)
    }

    // nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamMovieDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieReadStreamMovieDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieReadStreamMovieDataSize)
    }

    // nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadMovieDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadMovieDataFromAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadMovieDataFromAlbumMovieReadStream)
    }

    // nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieReadStreamBrokenReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieReadStreamBrokenReason)
    }

    // nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieReadStreamImageDataSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieReadStreamImageDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieReadStreamImageDataSize)
    }

    // nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadImageDataFromAlbumMovieReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadImageDataFromAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadImageDataFromAlbumMovieReadStream)
    }

    // nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadFileAttributeFromAlbumMovieReadStream, (::nn::sf::Out<::nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, ::nn::capsrv::detail::AlbumMovieReadStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadFileAttributeFromAlbumMovieReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAttribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadFileAttributeFromAlbumMovieReadStream)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IMovieReadStreamServiceObject>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieReadStreamMovieDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieReadStreamMovieDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadMovieDataFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadMovieDataFromAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReadSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieReadStreamBrokenReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieReadStreamBrokenReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieReadStreamImageDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieReadStreamImageDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadImageDataFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadImageDataFromAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReadSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadFileAttributeFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadFileAttributeFromAlbumMovieReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outAttribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieReadStreamMovieDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadMovieDataFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieReadStreamBrokenReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieReadStreamImageDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadImageDataFromAlbumMovieReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadFileAttributeFromAlbumMovieReadStream)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IMovieReadStreamServiceObject))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAlbumAccessorSession, (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAlbumAccessorSession)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAlbumAccessorSession)

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAlbumAccessorSession : public ::nn::capsrv::sf::IMovieReadStreamServiceObject
    {
    public:
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::capsrv::sf::IAlbumAccessorSession), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IAlbumAccessorSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::capsrv::sf::IAlbumAccessorSession), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IAlbumAccessorSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::capsrv::sf::IAlbumAccessorSession), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IAlbumAccessorSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::capsrv::sf::IAlbumAccessorSession), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IAlbumAccessorSession))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAlbumApplicationService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAlbumApplicationService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::std::int64_t beginPosixTime, ::std::int64_t endPosixTime, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruid, (const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::capsrv::AlbumFileContentsType contents, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileSizeByAruid, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruidForDebug, (const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageByAruid, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageByAruid, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrecheckToCreateContentsByAruid, (::nn::capsrv::AlbumFileContentsType contents, ::std::uint64_t size, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0ByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx1ByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, const ::nn::account::Uid& uid, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessorSessionForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAlbumApplicationService)

        ::nn::Result GetAlbumFileListByAruid(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::std::int64_t beginPosixTime, ::std::int64_t endPosixTime, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileListByAruid, (outCount, pOutList, contents, beginPosixTime, endPosixTime, aruid));
        }

        ::nn::Result DeleteAlbumFileByAruid(const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::capsrv::AlbumFileContentsType contents, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruid, (entry, contents, aruid));
        }

        ::nn::Result GetAlbumFileSizeByAruid(::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileSizeByAruid, (outSize, entry, aruid));
        }

        ::nn::Result DeleteAlbumFileByAruidForDebug(const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruidForDebug, (entry, aruid));
        }

        ::nn::Result LoadAlbumScreenShotImageByAruid(::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageByAruid, (output, outBuffer, entry, option, workBuffer, aruid));
        }

        ::nn::Result LoadAlbumScreenShotThumbnailImageByAruid(::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageByAruid, (output, outBuffer, entry, option, workBuffer, aruid));
        }

        ::nn::Result PrecheckToCreateContentsByAruid(::nn::capsrv::AlbumFileContentsType contents, ::std::uint64_t size, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrecheckToCreateContentsByAruid, (contents, size, aruid));
        }

        ::nn::Result GetAlbumFileListEx0ByAruid(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0ByAruid, (outCount, pOutList, contents, beginDateTime, endDateTime, aruid));
        }

        ::nn::Result GetAlbumFileListEx1ByAruid(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, const ::nn::account::Uid& uid, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumFileListEx1ByAruid, (outCount, pOutList, contents, uid, beginDateTime, endDateTime, aruid));
        }

        ::nn::Result OpenAccessorSessionForApplication(::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAccessorSessionForApplication, (outValue, entry, aruid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAlbumApplicationService
    {
    public:
        nn::Result GetAlbumFileListByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, std::int64_t beginPosixTime, std::int64_t endPosixTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DeleteAlbumFileByAruid(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::capsrv::AlbumFileContentsType contents, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result GetAlbumFileSizeByAruid(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DeleteAlbumFileByAruidForDebug(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result PrecheckToCreateContentsByAruid(nn::capsrv::AlbumFileContentsType contents, std::uint64_t size, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result GetAlbumFileListEx0ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result GetAlbumFileListEx1ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, const nn::account::Uid& uid, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result OpenAccessorSessionForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetAlbumFileListByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, std::int64_t beginPosixTime, std::int64_t endPosixTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DeleteAlbumFileByAruid(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::capsrv::AlbumFileContentsType contents, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetAlbumFileSizeByAruid(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DeleteAlbumFileByAruidForDebug(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result LoadAlbumScreenShotThumbnailImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result PrecheckToCreateContentsByAruid(nn::capsrv::AlbumFileContentsType contents, std::uint64_t size, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetAlbumFileListEx0ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetAlbumFileListEx1ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, const nn::account::Uid& uid, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result OpenAccessorSessionForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IAlbumApplicationService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::std::int64_t beginPosixTime, ::std::int64_t endPosixTime, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileListByAruid, (outCount, pOutList, contents, beginPosixTime, endPosixTime, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruid, (const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::capsrv::AlbumFileContentsType contents, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteAlbumFileByAruid, (entry, contents, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileSizeByAruid, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileSizeByAruid, (outSize, entry, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruidForDebug, (const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteAlbumFileByAruidForDebug, (entry, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageByAruid, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotImageByAruid, (output, outBuffer, entry, option, workBuffer, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageByAruid, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageByAruid, (output, outBuffer, entry, option, workBuffer, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrecheckToCreateContentsByAruid, (::nn::capsrv::AlbumFileContentsType contents, ::std::uint64_t size, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrecheckToCreateContentsByAruid, (contents, size, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0ByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileListEx0ByAruid, (outCount, pOutList, contents, beginDateTime, endDateTime, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx1ByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, const ::nn::account::Uid& uid, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumFileListEx1ByAruid, (outCount, pOutList, contents, uid, beginDateTime, endDateTime, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessorSessionForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAccessorSessionForApplication, (outValue, entry, aruid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IAlbumApplicationService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IAlbumApplicationService))

    // nn::Result GetAlbumFileListByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, std::int64_t beginPosixTime, std::int64_t endPosixTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileListByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutList, 0, (const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contents, (::nn::capsrv::AlbumFileContentsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beginPosixTime, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(endPosixTime, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (contents, beginPosixTime, endPosixTime, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contents), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beginPosixTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(endPosixTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileListByAruid)

    // nn::Result DeleteAlbumFileByAruid(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::capsrv::AlbumFileContentsType contents, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAlbumFileByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contents, (::nn::capsrv::AlbumFileContentsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (contents, entry, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contents), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAlbumFileByAruid)

    // nn::Result GetAlbumFileSizeByAruid(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileSizeByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (entry, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileSizeByAruid)

    // nn::Result DeleteAlbumFileByAruidForDebug(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteAlbumFileByAruidForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(105)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (entry, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteAlbumFileByAruidForDebug)

    // nn::Result LoadAlbumScreenShotImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotImageByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(output, 0, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication>), 1280, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (output, outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 48)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (entry, option, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotImageByAruid)

    // nn::Result LoadAlbumScreenShotThumbnailImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAlbumScreenShotThumbnailImageByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(output, 0, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication>), 1280, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(workBuffer, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (output, outBuffer, workBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 48)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (entry, option, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAlbumScreenShotThumbnailImageByAruid)

    // nn::Result PrecheckToCreateContentsByAruid(nn::capsrv::AlbumFileContentsType contents, std::uint64_t size, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrecheckToCreateContentsByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contents, (::nn::capsrv::AlbumFileContentsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (contents, size, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contents), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrecheckToCreateContentsByAruid)

    // nn::Result GetAlbumFileListEx0ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileListEx0ByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(140)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutList, 0, (const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contents, (::nn::capsrv::AlbumFileContentsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beginDateTime, (::nn::capsrv::AlbumFileDateTime), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(endDateTime, (::nn::capsrv::AlbumFileDateTime), 10)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (contents, beginDateTime, endDateTime, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contents), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beginDateTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(endDateTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileListEx0ByAruid)

    // nn::Result GetAlbumFileListEx1ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, const nn::account::Uid& uid, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumFileListEx1ByAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(141)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutList, 0, (const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contents, (::nn::capsrv::AlbumFileContentsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beginDateTime, (::nn::capsrv::AlbumFileDateTime), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(endDateTime, (::nn::capsrv::AlbumFileDateTime), 10)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (contents, beginDateTime, endDateTime, uid, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contents), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beginDateTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(endDateTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumFileListEx1ByAruid)

    // nn::Result OpenAccessorSessionForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAccessorSessionForApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entry, (::nn::capsrv::ApplicationAlbumFileEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (entry, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAccessorSessionForApplication)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumFileEntry), 48, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileContentsType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication), 1280, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ScreenShotDecodeOption), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileDateTime), 8, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IAlbumApplicationService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IAlbumApplicationService))

    // nn::Result GetAlbumFileListByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, std::int64_t beginPosixTime, std::int64_t endPosixTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::std::int64_t beginPosixTime, ::std::int64_t endPosixTime, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileListByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contents)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beginPosixTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(endPosixTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileListByAruid)
    }

    // nn::Result DeleteAlbumFileByAruid(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::capsrv::AlbumFileContentsType contents, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruid, (const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::capsrv::AlbumFileContentsType contents, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAlbumFileByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contents)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAlbumFileByAruid)
    }

    // nn::Result GetAlbumFileSizeByAruid(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileSizeByAruid, (::nn::sf::Out<::std::uint64_t> outSize, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileSizeByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileSizeByAruid)
    }

    // nn::Result DeleteAlbumFileByAruidForDebug(const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteAlbumFileByAruidForDebug, (const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteAlbumFileByAruidForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteAlbumFileByAruidForDebug)
    }

    // nn::Result LoadAlbumScreenShotImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotImageByAruid, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotImageByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotImageByAruid)
    }

    // nn::Result LoadAlbumScreenShotThumbnailImageByAruid(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::ApplicationAlbumFileEntry& entry, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadAlbumScreenShotThumbnailImageByAruid, (::nn::sf::Out<::nn::capsrv::sf::LoadAlbumScreenShotImageOutputForApplication> output, const ::nn::sf::OutBuffer& outBuffer, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, const ::nn::capsrv::ScreenShotDecodeOption& option, const ::nn::sf::OutBuffer& workBuffer, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAlbumScreenShotThumbnailImageByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAlbumScreenShotThumbnailImageByAruid)
    }

    // nn::Result PrecheckToCreateContentsByAruid(nn::capsrv::AlbumFileContentsType contents, std::uint64_t size, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrecheckToCreateContentsByAruid, (::nn::capsrv::AlbumFileContentsType contents, ::std::uint64_t size, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrecheckToCreateContentsByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contents)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrecheckToCreateContentsByAruid)
    }

    // nn::Result GetAlbumFileListEx0ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx0ByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileListEx0ByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contents)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beginDateTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(endDateTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileListEx0ByAruid)
    }

    // nn::Result GetAlbumFileListEx1ByAruid(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::ApplicationAlbumFileEntry>& pOutList, nn::capsrv::AlbumFileContentsType contents, const nn::account::Uid& uid, nn::capsrv::AlbumFileDateTime beginDateTime, nn::capsrv::AlbumFileDateTime endDateTime, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumFileListEx1ByAruid, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutArray<::nn::capsrv::ApplicationAlbumFileEntry>& pOutList, ::nn::capsrv::AlbumFileContentsType contents, const ::nn::account::Uid& uid, ::nn::capsrv::AlbumFileDateTime beginDateTime, ::nn::capsrv::AlbumFileDateTime endDateTime, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumFileListEx1ByAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contents)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beginDateTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(endDateTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumFileListEx1ByAruid)
    }

    // nn::Result OpenAccessorSessionForApplication(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const nn::capsrv::ApplicationAlbumFileEntry& entry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAccessorSessionForApplication, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorApplicationSession>> outValue, const ::nn::capsrv::ApplicationAlbumFileEntry& entry, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAccessorSessionForApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAccessorSessionForApplication)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IAlbumApplicationService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IAlbumApplicationService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileListByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileListByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contents),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beginPosixTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(endPosixTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAlbumFileByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAlbumFileByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contents),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileSizeByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileSizeByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteAlbumFileByAruidForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteAlbumFileByAruidForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotImageByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotImageByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAlbumScreenShotThumbnailImageByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(workBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAlbumScreenShotThumbnailImageByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(workBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrecheckToCreateContentsByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrecheckToCreateContentsByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contents),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileListEx0ByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileListEx0ByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contents),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beginDateTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(endDateTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumFileListEx1ByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumFileListEx1ByAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contents),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beginDateTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(endDateTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAccessorSessionForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumAccessorApplicationSession>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAccessorSessionForApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileListByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAlbumFileByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileSizeByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteAlbumFileByAruidForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotImageByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAlbumScreenShotThumbnailImageByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrecheckToCreateContentsByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileListEx0ByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumFileListEx1ByAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAccessorSessionForApplication)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IAlbumApplicationService))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAlbumControlService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAlbumControlService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsAvailable, (::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsUnavailable, (::nn::capsrv::AlbumStorageType storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserId, (::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserId, (::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationIdFromAruid, (::nn::sf::Out<::nn::ncm::ApplicationId> outApplicationId, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationIdRegistered, (::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCurrentAlbumFileId, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::ncm::ProgramId programId, ::nn::capsrv::AlbumFileContentsType contentType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateApplicationAlbumEnrty, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::capsrv::AlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveAlbumScreenShotFileEx, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& fileData, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOverlayScreenShotThumbnailData, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOverlayMovieThumbnailData, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenControlSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumControlSession>> outValue, ::nn::applet::AppletResourceUserId aruid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAlbumControlService)

        ::nn::Result NotifyAlbumStorageIsAvailable(::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsAvailable, (storage));
        }

        ::nn::Result NotifyAlbumStorageIsUnavailable(::nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsUnavailable, (storage));
        }

        ::nn::Result RegisterAppletResourceUserId(::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserId, (aruid, applicationId));
        }

        ::nn::Result UnregisterAppletResourceUserId(::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserId, (aruid, applicationId));
        }

        ::nn::Result GetApplicationIdFromAruid(::nn::sf::Out<::nn::ncm::ApplicationId> outApplicationId, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationIdFromAruid, (outApplicationId, aruid));
        }

        ::nn::Result CheckApplicationIdRegistered(::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckApplicationIdRegistered, (applicationId));
        }

        ::nn::Result GenerateCurrentAlbumFileId(::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::ncm::ProgramId programId, ::nn::capsrv::AlbumFileContentsType contentType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateCurrentAlbumFileId, (outFileId, programId, contentType));
        }

        ::nn::Result GenerateApplicationAlbumEnrty(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::capsrv::AlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateApplicationAlbumEnrty, (outEntry, srcEntry, applicationId));
        }

        ::nn::Result SaveAlbumScreenShotFileEx(const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& fileData, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveAlbumScreenShotFileEx, (fileId, fileData, makerNoteVersion, makerNoteOffset, makerNoteSize));
        }

        ::nn::Result SetOverlayScreenShotThumbnailData(const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOverlayScreenShotThumbnailData, (fileId, thumbData));
        }

        ::nn::Result SetOverlayMovieThumbnailData(const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOverlayMovieThumbnailData, (fileId, thumbData));
        }

        ::nn::Result OpenControlSession(::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumControlSession>> outValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenControlSession, (outValue, aruid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAlbumControlService
    {
    public:
        nn::Result NotifyAlbumStorageIsAvailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result NotifyAlbumStorageIsUnavailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GetApplicationIdFromAruid(nn::sf::Out<nn::ncm::ApplicationId> outApplicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CheckApplicationIdRegistered(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GenerateCurrentAlbumFileId(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::ncm::ProgramId programId, nn::capsrv::AlbumFileContentsType contentType) NN_NOEXCEPT;
        nn::Result GenerateApplicationAlbumEnrty(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::capsrv::AlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result SaveAlbumScreenShotFileEx(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& fileData, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT;
        nn::Result SetOverlayScreenShotThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT;
        nn::Result SetOverlayMovieThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT;
        nn::Result OpenControlSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumControlSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result NotifyAlbumStorageIsAvailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result NotifyAlbumStorageIsUnavailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
    nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result GetApplicationIdFromAruid(nn::sf::Out<nn::ncm::ApplicationId> outApplicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result CheckApplicationIdRegistered(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result GenerateCurrentAlbumFileId(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::ncm::ProgramId programId, nn::capsrv::AlbumFileContentsType contentType) NN_NOEXCEPT;
    nn::Result GenerateApplicationAlbumEnrty(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::capsrv::AlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result SaveAlbumScreenShotFileEx(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& fileData, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT;
    nn::Result SetOverlayScreenShotThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT;
    nn::Result SetOverlayMovieThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT;
    nn::Result OpenControlSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumControlSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IAlbumControlService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsAvailable, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyAlbumStorageIsAvailable, (storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsUnavailable, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyAlbumStorageIsUnavailable, (storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserId, (::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterAppletResourceUserId, (aruid, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserId, (::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterAppletResourceUserId, (aruid, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationIdFromAruid, (::nn::sf::Out<::nn::ncm::ApplicationId> outApplicationId, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationIdFromAruid, (outApplicationId, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationIdRegistered, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckApplicationIdRegistered, (applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCurrentAlbumFileId, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::ncm::ProgramId programId, ::nn::capsrv::AlbumFileContentsType contentType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateCurrentAlbumFileId, (outFileId, programId, contentType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateApplicationAlbumEnrty, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::capsrv::AlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateApplicationAlbumEnrty, (outEntry, srcEntry, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveAlbumScreenShotFileEx, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& fileData, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveAlbumScreenShotFileEx, (fileId, fileData, makerNoteVersion, makerNoteOffset, makerNoteSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOverlayScreenShotThumbnailData, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOverlayScreenShotThumbnailData, (fileId, thumbData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOverlayMovieThumbnailData, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOverlayMovieThumbnailData, (fileId, thumbData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenControlSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumControlSession>> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenControlSession, (outValue, aruid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IAlbumControlService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IAlbumControlService))

    // nn::Result NotifyAlbumStorageIsAvailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyAlbumStorageIsAvailable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyAlbumStorageIsAvailable)

    // nn::Result NotifyAlbumStorageIsUnavailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyAlbumStorageIsUnavailable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::capsrv::AlbumStorageType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyAlbumStorageIsUnavailable)

    // nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterAppletResourceUserId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterAppletResourceUserId)

    // nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAppletResourceUserId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2012)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAppletResourceUserId)

    // nn::Result GetApplicationIdFromAruid(nn::sf::Out<nn::ncm::ApplicationId> outApplicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationIdFromAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2013)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outApplicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outApplicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outApplicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationIdFromAruid)

    // nn::Result CheckApplicationIdRegistered(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckApplicationIdRegistered)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2014)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckApplicationIdRegistered)

    // nn::Result GenerateCurrentAlbumFileId(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::ncm::ProgramId programId, nn::capsrv::AlbumFileContentsType contentType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateCurrentAlbumFileId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentType, (::nn::capsrv::AlbumFileContentsType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (contentType, programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateCurrentAlbumFileId)

    // nn::Result GenerateApplicationAlbumEnrty(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::capsrv::AlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateApplicationAlbumEnrty)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcEntry, (::nn::capsrv::AlbumEntry), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (srcEntry, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateApplicationAlbumEnrty)

    // nn::Result SaveAlbumScreenShotFileEx(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& fileData, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveAlbumScreenShotFileEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(fileData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (fileData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(makerNoteVersion, (::std::uint64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(makerNoteOffset, (::std::int64_t), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(makerNoteSize, (::std::int64_t), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (fileId, makerNoteVersion, makerNoteOffset, makerNoteSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(makerNoteVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(makerNoteOffset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(makerNoteSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveAlbumScreenShotFileEx)

    // nn::Result SetOverlayScreenShotThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOverlayScreenShotThumbnailData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (thumbData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOverlayScreenShotThumbnailData)

    // nn::Result SetOverlayMovieThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOverlayMovieThumbnailData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (thumbData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOverlayMovieThumbnailData)

    // nn::Result OpenControlSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumControlSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenControlSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenControlSession)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumStorageType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileContentsType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IAlbumControlService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IAlbumControlService))

    // nn::Result NotifyAlbumStorageIsAvailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsAvailable, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyAlbumStorageIsAvailable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyAlbumStorageIsAvailable)
    }

    // nn::Result NotifyAlbumStorageIsUnavailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAlbumStorageIsUnavailable, (::nn::capsrv::AlbumStorageType storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyAlbumStorageIsUnavailable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyAlbumStorageIsUnavailable)
    }

    // nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterAppletResourceUserId, (::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterAppletResourceUserId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterAppletResourceUserId)
    }

    // nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterAppletResourceUserId, (::nn::applet::AppletResourceUserId aruid, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAppletResourceUserId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAppletResourceUserId)
    }

    // nn::Result GetApplicationIdFromAruid(nn::sf::Out<nn::ncm::ApplicationId> outApplicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationIdFromAruid, (::nn::sf::Out<::nn::ncm::ApplicationId> outApplicationId, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationIdFromAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outApplicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationIdFromAruid)
    }

    // nn::Result CheckApplicationIdRegistered(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationIdRegistered, (::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckApplicationIdRegistered)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckApplicationIdRegistered)
    }

    // nn::Result GenerateCurrentAlbumFileId(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::ncm::ProgramId programId, nn::capsrv::AlbumFileContentsType contentType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCurrentAlbumFileId, (::nn::sf::Out<::nn::capsrv::AlbumFileId> outFileId, ::nn::ncm::ProgramId programId, ::nn::capsrv::AlbumFileContentsType contentType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateCurrentAlbumFileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateCurrentAlbumFileId)
    }

    // nn::Result GenerateApplicationAlbumEnrty(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::capsrv::AlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateApplicationAlbumEnrty, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::capsrv::AlbumEntry& srcEntry, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateApplicationAlbumEnrty)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateApplicationAlbumEnrty)
    }

    // nn::Result SaveAlbumScreenShotFileEx(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& fileData, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveAlbumScreenShotFileEx, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& fileData, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveAlbumScreenShotFileEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(makerNoteVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(makerNoteOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(makerNoteSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveAlbumScreenShotFileEx)
    }

    // nn::Result SetOverlayScreenShotThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOverlayScreenShotThumbnailData, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOverlayScreenShotThumbnailData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOverlayScreenShotThumbnailData)
    }

    // nn::Result SetOverlayMovieThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOverlayMovieThumbnailData, (const ::nn::capsrv::AlbumFileId& fileId, const ::nn::sf::InBuffer& thumbData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOverlayMovieThumbnailData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOverlayMovieThumbnailData)
    }

    // nn::Result OpenControlSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumControlSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenControlSession, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumControlSession>> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenControlSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenControlSession)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IAlbumControlService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IAlbumControlService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyAlbumStorageIsAvailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyAlbumStorageIsAvailable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyAlbumStorageIsUnavailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyAlbumStorageIsUnavailable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterAppletResourceUserId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterAppletResourceUserId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAppletResourceUserId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAppletResourceUserId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationIdFromAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationIdFromAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outApplicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckApplicationIdRegistered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckApplicationIdRegistered)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateCurrentAlbumFileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateCurrentAlbumFileId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateApplicationAlbumEnrty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateApplicationAlbumEnrty)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveAlbumScreenShotFileEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(fileData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveAlbumScreenShotFileEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(fileData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(makerNoteVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(makerNoteOffset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(makerNoteSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOverlayScreenShotThumbnailData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOverlayScreenShotThumbnailData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOverlayMovieThumbnailData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOverlayMovieThumbnailData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenControlSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::capsrv::sf::IAlbumControlSession>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenControlSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyAlbumStorageIsAvailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyAlbumStorageIsUnavailable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterAppletResourceUserId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAppletResourceUserId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationIdFromAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckApplicationIdRegistered)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateCurrentAlbumFileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateApplicationAlbumEnrty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveAlbumScreenShotFileEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOverlayScreenShotThumbnailData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOverlayMovieThumbnailData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenControlSession)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IAlbumControlService))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IMovieWriteStreamServiceObject, (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IMovieWriteStreamServiceObject)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieWriteStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinishAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStreamNoDelete, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamDataSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamDataSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamMetaSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamMetaSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadDataFromAlbumMovieWriteStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteDataToAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset, const ::nn::sf::InBuffer& inBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteMetaToAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const ::nn::sf::InBuffer& inBuffer, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamDataSize, (::nn::sf::Out<::std::int64_t> outValue, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAlbumMovieWriteStreamDataSize, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t value))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IMovieWriteStreamServiceObject)

        ::nn::Result OpenAlbumMovieWriteStream(::nn::sf::Out<::nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenAlbumMovieWriteStream, (outHandle, fileId));
        }

        ::nn::Result FinishAlbumMovieWriteStream(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinishAlbumMovieWriteStream, (handle));
        }

        ::nn::Result CommitAlbumMovieWriteStream(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitAlbumMovieWriteStream, (handle));
        }

        ::nn::Result DiscardAlbumMovieWriteStream(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStream, (handle));
        }

        ::nn::Result DiscardAlbumMovieWriteStreamNoDelete(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStreamNoDelete, (handle));
        }

        ::nn::Result StartAlbumMovieWriteStreamDataSection(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamDataSection, (handle));
        }

        ::nn::Result EndAlbumMovieWriteStreamDataSection(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamDataSection, (handle));
        }

        ::nn::Result StartAlbumMovieWriteStreamMetaSection(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamMetaSection, (handle));
        }

        ::nn::Result EndAlbumMovieWriteStreamMetaSection(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamMetaSection, (handle));
        }

        ::nn::Result ReadDataFromAlbumMovieWriteStream(::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadDataFromAlbumMovieWriteStream, (outReadSize, outBuffer, handle, offset));
        }

        ::nn::Result WriteDataToAlbumMovieWriteStream(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset, const ::nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteDataToAlbumMovieWriteStream, (handle, offset, inBuffer));
        }

        ::nn::Result WriteMetaToAlbumMovieWriteStream(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const ::nn::sf::InBuffer& inBuffer, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteMetaToAlbumMovieWriteStream, (handle, inBuffer, makerNoteVersion, makerNoteOffset, makerNoteSize));
        }

        ::nn::Result GetAlbumMovieWriteStreamBrokenReason(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamBrokenReason, (handle));
        }

        ::nn::Result GetAlbumMovieWriteStreamDataSize(::nn::sf::Out<::std::int64_t> outValue, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamDataSize, (outValue, handle));
        }

        ::nn::Result SetAlbumMovieWriteStreamDataSize(::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAlbumMovieWriteStreamDataSize, (handle, value));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IMovieWriteStreamServiceObject : public ::nn::capsrv::sf::IMovieReadStreamServiceObject
    {
    public:
        nn::Result OpenAlbumMovieWriteStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result FinishAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result CommitAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result DiscardAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result DiscardAlbumMovieWriteStreamNoDelete(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result StartAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result EndAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result StartAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result EndAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadDataFromAlbumMovieWriteStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result WriteDataToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
        nn::Result WriteMetaToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const nn::sf::InBuffer& inBuffer, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT;
        nn::Result GetAlbumMovieWriteStreamBrokenReason(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieWriteStreamDataSize(nn::sf::Out<std::int64_t> outValue, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result SetAlbumMovieWriteStreamDataSize(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t value) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result OpenAlbumMovieWriteStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result FinishAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result CommitAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result DiscardAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result DiscardAlbumMovieWriteStreamNoDelete(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result StartAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result EndAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result StartAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result EndAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadDataFromAlbumMovieWriteStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result WriteDataToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    nn::Result WriteMetaToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const nn::sf::InBuffer& inBuffer, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT;
    nn::Result GetAlbumMovieWriteStreamBrokenReason(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieWriteStreamDataSize(nn::sf::Out<std::int64_t> outValue, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result SetAlbumMovieWriteStreamDataSize(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t value) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::capsrv::sf::IMovieWriteStreamServiceObject), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieWriteStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenAlbumMovieWriteStream, (outHandle, fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinishAlbumMovieWriteStream, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitAlbumMovieWriteStream, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DiscardAlbumMovieWriteStream, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStreamNoDelete, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DiscardAlbumMovieWriteStreamNoDelete, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamDataSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartAlbumMovieWriteStreamDataSection, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamDataSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EndAlbumMovieWriteStreamDataSection, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamMetaSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartAlbumMovieWriteStreamMetaSection, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamMetaSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EndAlbumMovieWriteStreamMetaSection, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadDataFromAlbumMovieWriteStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadDataFromAlbumMovieWriteStream, (outReadSize, outBuffer, handle, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteDataToAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset, const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteDataToAlbumMovieWriteStream, (handle, offset, inBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteMetaToAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const ::nn::sf::InBuffer& inBuffer, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteMetaToAlbumMovieWriteStream, (handle, inBuffer, makerNoteVersion, makerNoteOffset, makerNoteSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieWriteStreamBrokenReason, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamDataSize, (::nn::sf::Out<::std::int64_t> outValue, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAlbumMovieWriteStreamDataSize, (outValue, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAlbumMovieWriteStreamDataSize, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAlbumMovieWriteStreamDataSize, (handle, value));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IMovieWriteStreamServiceObject>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::capsrv::sf::IMovieWriteStreamServiceObject), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    // nn::Result OpenAlbumMovieWriteStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenAlbumMovieWriteStream)

    // nn::Result FinishAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinishAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinishAlbumMovieWriteStream)

    // nn::Result CommitAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2403)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitAlbumMovieWriteStream)

    // nn::Result DiscardAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DiscardAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2404)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DiscardAlbumMovieWriteStream)

    // nn::Result DiscardAlbumMovieWriteStreamNoDelete(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DiscardAlbumMovieWriteStreamNoDelete)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2405)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DiscardAlbumMovieWriteStreamNoDelete)

    // nn::Result StartAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartAlbumMovieWriteStreamDataSection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2411)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartAlbumMovieWriteStreamDataSection)

    // nn::Result EndAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndAlbumMovieWriteStreamDataSection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2412)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndAlbumMovieWriteStreamDataSection)

    // nn::Result StartAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartAlbumMovieWriteStreamMetaSection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2413)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartAlbumMovieWriteStreamMetaSection)

    // nn::Result EndAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndAlbumMovieWriteStreamMetaSection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2414)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndAlbumMovieWriteStreamMetaSection)

    // nn::Result ReadDataFromAlbumMovieWriteStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadDataFromAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2421)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReadSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outReadSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadDataFromAlbumMovieWriteStream)

    // nn::Result WriteDataToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteDataToAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2422)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteDataToAlbumMovieWriteStream)

    // nn::Result WriteMetaToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const nn::sf::InBuffer& inBuffer, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteMetaToAlbumMovieWriteStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2424)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(makerNoteVersion, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(makerNoteOffset, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(makerNoteSize, (::std::int64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, makerNoteVersion, makerNoteOffset, makerNoteSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(makerNoteVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(makerNoteOffset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(makerNoteSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteMetaToAlbumMovieWriteStream)

    // nn::Result GetAlbumMovieWriteStreamBrokenReason(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieWriteStreamBrokenReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2431)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieWriteStreamBrokenReason)

    // nn::Result GetAlbumMovieWriteStreamDataSize(nn::sf::Out<std::int64_t> outValue, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAlbumMovieWriteStreamDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2433)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAlbumMovieWriteStreamDataSize)

    // nn::Result SetAlbumMovieWriteStreamDataSize(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAlbumMovieWriteStreamDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2434)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAlbumMovieWriteStreamDataSize)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IMovieWriteStreamServiceObject, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::capsrv::sf::IMovieWriteStreamServiceObject), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    // nn::Result OpenAlbumMovieWriteStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenAlbumMovieWriteStream, (::nn::sf::Out<::nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenAlbumMovieWriteStream)
    }

    // nn::Result FinishAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinishAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinishAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinishAlbumMovieWriteStream)
    }

    // nn::Result CommitAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitAlbumMovieWriteStream)
    }

    // nn::Result DiscardAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DiscardAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DiscardAlbumMovieWriteStream)
    }

    // nn::Result DiscardAlbumMovieWriteStreamNoDelete(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DiscardAlbumMovieWriteStreamNoDelete, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DiscardAlbumMovieWriteStreamNoDelete)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DiscardAlbumMovieWriteStreamNoDelete)
    }

    // nn::Result StartAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamDataSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartAlbumMovieWriteStreamDataSection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartAlbumMovieWriteStreamDataSection)
    }

    // nn::Result EndAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamDataSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndAlbumMovieWriteStreamDataSection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndAlbumMovieWriteStreamDataSection)
    }

    // nn::Result StartAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartAlbumMovieWriteStreamMetaSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartAlbumMovieWriteStreamMetaSection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartAlbumMovieWriteStreamMetaSection)
    }

    // nn::Result EndAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EndAlbumMovieWriteStreamMetaSection, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndAlbumMovieWriteStreamMetaSection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndAlbumMovieWriteStreamMetaSection)
    }

    // nn::Result ReadDataFromAlbumMovieWriteStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadDataFromAlbumMovieWriteStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadDataFromAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadDataFromAlbumMovieWriteStream)
    }

    // nn::Result WriteDataToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteDataToAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t offset, const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteDataToAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteDataToAlbumMovieWriteStream)
    }

    // nn::Result WriteMetaToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const nn::sf::InBuffer& inBuffer, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteMetaToAlbumMovieWriteStream, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const ::nn::sf::InBuffer& inBuffer, ::std::uint64_t makerNoteVersion, ::std::int64_t makerNoteOffset, ::std::int64_t makerNoteSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteMetaToAlbumMovieWriteStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(makerNoteVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(makerNoteOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(makerNoteSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteMetaToAlbumMovieWriteStream)
    }

    // nn::Result GetAlbumMovieWriteStreamBrokenReason(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamBrokenReason, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieWriteStreamBrokenReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieWriteStreamBrokenReason)
    }

    // nn::Result GetAlbumMovieWriteStreamDataSize(nn::sf::Out<std::int64_t> outValue, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAlbumMovieWriteStreamDataSize, (::nn::sf::Out<::std::int64_t> outValue, ::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAlbumMovieWriteStreamDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAlbumMovieWriteStreamDataSize)
    }

    // nn::Result SetAlbumMovieWriteStreamDataSize(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAlbumMovieWriteStreamDataSize, (::nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, ::std::int64_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAlbumMovieWriteStreamDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAlbumMovieWriteStreamDataSize)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IMovieWriteStreamServiceObject>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::capsrv::sf::IMovieWriteStreamServiceObject), (::nn::capsrv::sf::IMovieReadStreamServiceObject))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinishAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinishAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DiscardAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DiscardAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DiscardAlbumMovieWriteStreamNoDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DiscardAlbumMovieWriteStreamNoDelete)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartAlbumMovieWriteStreamDataSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartAlbumMovieWriteStreamDataSection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndAlbumMovieWriteStreamDataSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndAlbumMovieWriteStreamDataSection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartAlbumMovieWriteStreamMetaSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartAlbumMovieWriteStreamMetaSection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndAlbumMovieWriteStreamMetaSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndAlbumMovieWriteStreamMetaSection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadDataFromAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadDataFromAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReadSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteDataToAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteDataToAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteMetaToAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteMetaToAlbumMovieWriteStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(makerNoteVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(makerNoteOffset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(makerNoteSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieWriteStreamBrokenReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieWriteStreamBrokenReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAlbumMovieWriteStreamDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAlbumMovieWriteStreamDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAlbumMovieWriteStreamDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAlbumMovieWriteStreamDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinishAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DiscardAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DiscardAlbumMovieWriteStreamNoDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartAlbumMovieWriteStreamDataSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndAlbumMovieWriteStreamDataSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartAlbumMovieWriteStreamMetaSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndAlbumMovieWriteStreamMetaSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadDataFromAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteDataToAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteMetaToAlbumMovieWriteStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieWriteStreamBrokenReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAlbumMovieWriteStreamDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAlbumMovieWriteStreamDataSize)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IMovieWriteStreamServiceObject))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAlbumControlSession, (::nn::capsrv::sf::IMovieWriteStreamServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAlbumControlSession)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAlbumControlSession)

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAlbumControlSession : public ::nn::capsrv::sf::IMovieWriteStreamServiceObject
    {
    public:
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
    nn::Result OpenAlbumMovieWriteStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result FinishAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result CommitAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result DiscardAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result DiscardAlbumMovieWriteStreamNoDelete(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result StartAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result EndAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result StartAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result EndAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result ReadDataFromAlbumMovieWriteStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
    nn::Result WriteDataToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    nn::Result WriteMetaToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const nn::sf::InBuffer& inBuffer, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT;
    nn::Result GetAlbumMovieWriteStreamBrokenReason(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result GetAlbumMovieWriteStreamDataSize(nn::sf::Out<std::int64_t> outValue, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
    nn::Result SetAlbumMovieWriteStreamDataSize(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t value) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::capsrv::sf::IAlbumControlSession), (::nn::capsrv::sf::IMovieWriteStreamServiceObject))

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IAlbumControlSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::capsrv::sf::IAlbumControlSession), (::nn::capsrv::sf::IMovieWriteStreamServiceObject))

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieReadStreamHandleType), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::AlbumMovieWriteStreamHandleType), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IAlbumControlSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::capsrv::sf::IAlbumControlSession), (::nn::capsrv::sf::IMovieWriteStreamServiceObject))

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IAlbumControlSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::capsrv::sf::IAlbumControlSession), (::nn::capsrv::sf::IMovieWriteStreamServiceObject))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IAlbumControlSession))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDecoderControlService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDecoderControlService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecodeJpeg, (const ::nn::sf::OutBuffer& outImageBuf, const ::nn::sf::InBuffer& inJpegBuf, ::std::uint32_t width, ::std::uint32_t height, const ::nn::capsrv::ScreenShotDecodeOption& option))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDecoderControlService)

        ::nn::Result DecodeJpeg(const ::nn::sf::OutBuffer& outImageBuf, const ::nn::sf::InBuffer& inJpegBuf, ::std::uint32_t width, ::std::uint32_t height, const ::nn::capsrv::ScreenShotDecodeOption& option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecodeJpeg, (outImageBuf, inJpegBuf, width, height, option));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDecoderControlService
    {
    public:
        nn::Result DecodeJpeg(const nn::sf::OutBuffer& outImageBuf, const nn::sf::InBuffer& inJpegBuf, std::uint32_t width, std::uint32_t height, const nn::capsrv::ScreenShotDecodeOption& option) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result DecodeJpeg(const nn::sf::OutBuffer& outImageBuf, const nn::sf::InBuffer& inJpegBuf, std::uint32_t width, std::uint32_t height, const nn::capsrv::ScreenShotDecodeOption& option) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IDecoderControlService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeJpeg, (const ::nn::sf::OutBuffer& outImageBuf, const ::nn::sf::InBuffer& inJpegBuf, ::std::uint32_t width, ::std::uint32_t height, const ::nn::capsrv::ScreenShotDecodeOption& option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecodeJpeg, (outImageBuf, inJpegBuf, width, height, option));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IDecoderControlService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IDecoderControlService))

    // nn::Result DecodeJpeg(const nn::sf::OutBuffer& outImageBuf, const nn::sf::InBuffer& inJpegBuf, std::uint32_t width, std::uint32_t height, const nn::capsrv::ScreenShotDecodeOption& option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecodeJpeg)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outImageBuf, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inJpegBuf, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outImageBuf, inJpegBuf))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::capsrv::ScreenShotDecodeOption), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (width, height, option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outImageBuf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inJpegBuf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecodeJpeg)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ScreenShotDecodeOption), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IDecoderControlService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IDecoderControlService))

    // nn::Result DecodeJpeg(const nn::sf::OutBuffer& outImageBuf, const nn::sf::InBuffer& inJpegBuf, std::uint32_t width, std::uint32_t height, const nn::capsrv::ScreenShotDecodeOption& option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecodeJpeg, (const ::nn::sf::OutBuffer& outImageBuf, const ::nn::sf::InBuffer& inJpegBuf, ::std::uint32_t width, ::std::uint32_t height, const ::nn::capsrv::ScreenShotDecodeOption& option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecodeJpeg)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outImageBuf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inJpegBuf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecodeJpeg)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IDecoderControlService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IDecoderControlService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecodeJpeg)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outImageBuf)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inJpegBuf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecodeJpeg)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outImageBuf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inJpegBuf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecodeJpeg)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IDecoderControlService))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IScreenShotApplicationService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IScreenShotApplicationService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShot, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx2, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IScreenShotApplicationService)

        ::nn::Result SaveScreenShot(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShot, (outEntry, imageBuffer, size, aruid, overlayRequest));
        }

        ::nn::Result SaveScreenShotEx0(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (outEntry, imageBuffer, attribute, aruid, overlayRequest));
        }

        ::nn::Result SaveScreenShotEx2(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShotEx2, (outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IScreenShotApplicationService
    {
    public:
        nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx2(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
    nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
    nn::Result SaveScreenShotEx2(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IScreenShotApplicationService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShot, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShot, (outEntry, imageBuffer, size, aruid, overlayRequest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShotEx0, (outEntry, imageBuffer, attribute, aruid, overlayRequest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx2, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShotEx2, (outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IScreenShotApplicationService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IScreenShotApplicationService))

    // nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::nn::capsrv::ScreenShotSizeType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(overlayRequest, (::nn::capsrv::OverlayNotificationRequestType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (size, overlayRequest, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(overlayRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShot)

    // nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShotEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(overlayRequest, (::nn::capsrv::OverlayNotificationRequestType), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (attribute, overlayRequest, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(overlayRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShotEx0)

    // nn::Result SaveScreenShotEx2(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShotEx2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(userIdList, 0, (const ::nn::capsrv::UserIdList&), 136, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (userIdList, imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(overlayRequest, (::nn::capsrv::OverlayNotificationRequestType), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (attribute, overlayRequest, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(overlayRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShotEx2)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ScreenShotSizeType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::OverlayNotificationRequestType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::UserIdList), 136, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IScreenShotApplicationService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IScreenShotApplicationService))

    // nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShot, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(overlayRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShot)
    }

    // nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShotEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(overlayRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShotEx0)
    }

    // nn::Result SaveScreenShotEx2(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx2, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShotEx2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(overlayRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShotEx2)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IScreenShotApplicationService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IScreenShotApplicationService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(overlayRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShotEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShotEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(overlayRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShotEx2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShotEx2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(overlayRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShotEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShotEx2)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IScreenShotApplicationService))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IScreenShotControlService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IScreenShotControlService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArray, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArrayWithTimeout, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index, ::nn::TimeSpan timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachSharedBufferToCaptureModule, (::nn::vi::fbshare::SharedBufferHandle hBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageToAttachedSharedBuffer, (::std::int32_t dstIndex, ::std::int32_t layerStack, ::nn::TimeSpan timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx2ViaAm, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestTakingScreenShotEx1, (::std::uint64_t seqNo, ::nn::ncm::ProgramId programId, ::nn::applet::AppletResourceUserId aruid, ::nn::TimeSpan timeout, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelTakingScreenShot, (::std::uint64_t seqNo, ::nn::Result reason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTakingScreenShotCancelState, (::std::uint64_t seqNo, ::nn::Result reason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotRefused, (::nn::ncm::ProgramId programId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotFailed, (::nn::ncm::ProgramId programId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetupOverlayMovieThumbnail, (const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataNv12Ex2, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataRgbaEx2, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::InBuffer& imageRgba, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenRawScreenShotReadStream, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::std::int32_t layerStack, ::nn::TimeSpan timeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseRawScreenShotReadStream)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadRawScreenShotReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t offset))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IScreenShotControlService)

        ::nn::Result CaptureRawImageRgba32IntoArray(const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArray, (pOutBuffer, layerStack, width, height, length, index));
        }

        ::nn::Result CaptureRawImageRgba32IntoArrayWithTimeout(const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index, ::nn::TimeSpan timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArrayWithTimeout, (pOutBuffer, layerStack, width, height, length, index, timeout));
        }

        ::nn::Result AttachSharedBufferToCaptureModule(::nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachSharedBufferToCaptureModule, (hBuffer));
        }

        ::nn::Result CaptureRawImageToAttachedSharedBuffer(::std::int32_t dstIndex, ::std::int32_t layerStack, ::nn::TimeSpan timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CaptureRawImageToAttachedSharedBuffer, (dstIndex, layerStack, timeout));
        }

        ::nn::Result SaveScreenShotEx2ViaAm(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShotEx2ViaAm, (outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest));
        }

        ::nn::Result RequestTakingScreenShotEx1(::std::uint64_t seqNo, ::nn::ncm::ProgramId programId, ::nn::applet::AppletResourceUserId aruid, ::nn::TimeSpan timeout, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestTakingScreenShotEx1, (seqNo, programId, aruid, timeout, attribute, userIdList));
        }

        ::nn::Result CancelTakingScreenShot(::std::uint64_t seqNo, ::nn::Result reason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelTakingScreenShot, (seqNo, reason));
        }

        ::nn::Result SetTakingScreenShotCancelState(::std::uint64_t seqNo, ::nn::Result reason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTakingScreenShotCancelState, (seqNo, reason));
        }

        ::nn::Result NotifyTakingScreenShotRefused(::nn::ncm::ProgramId programId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotRefused, (programId));
        }

        ::nn::Result NotifyTakingScreenShotFailed(::nn::ncm::ProgramId programId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotFailed, (programId));
        }

        ::nn::Result SetupOverlayMovieThumbnail(const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetupOverlayMovieThumbnail, (imageY, imageUv, width, height, fileId));
        }

        ::nn::Result CreateProtoMovieMetaDataNv12Ex2(::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataNv12Ex2, (outSize, outMakerNoteOffset, outMakerNoteSize, outMeta, imageY, imageUv, width, height, fileId, attribute, appletData, applicationData));
        }

        ::nn::Result CreateProtoMovieMetaDataRgbaEx2(::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::InBuffer& imageRgba, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataRgbaEx2, (outSize, outMakerNoteOffset, outMakerNoteSize, outMeta, imageRgba, width, height, fileId, attribute, appletData, applicationData));
        }

        ::nn::Result OpenRawScreenShotReadStream(::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::std::int32_t layerStack, ::nn::TimeSpan timeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenRawScreenShotReadStream, (outSize, outWidth, outHeight, layerStack, timeout));
        }

        ::nn::Result CloseRawScreenShotReadStream() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseRawScreenShotReadStream);
        }

        ::nn::Result ReadRawScreenShotReadStream(::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadRawScreenShotReadStream, (outReadSize, outBuffer, offset));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IScreenShotControlService
    {
    public:
        nn::Result CaptureRawImageRgba32IntoArray(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index) NN_NOEXCEPT;
        nn::Result CaptureRawImageRgba32IntoArrayWithTimeout(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result AttachSharedBufferToCaptureModule(nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT;
        nn::Result CaptureRawImageToAttachedSharedBuffer(std::int32_t dstIndex, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx2ViaAm(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result RequestTakingScreenShotEx1(std::uint64_t seqNo, nn::ncm::ProgramId programId, nn::applet::AppletResourceUserId aruid, nn::TimeSpan timeout, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList) NN_NOEXCEPT;
        nn::Result CancelTakingScreenShot(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;
        nn::Result SetTakingScreenShotCancelState(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;
        nn::Result NotifyTakingScreenShotRefused(nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result NotifyTakingScreenShotFailed(nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result SetupOverlayMovieThumbnail(const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result CreateProtoMovieMetaDataNv12Ex2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT;
        nn::Result CreateProtoMovieMetaDataRgbaEx2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::InBuffer& imageRgba, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT;
        nn::Result OpenRawScreenShotReadStream(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT;
        nn::Result CloseRawScreenShotReadStream() NN_NOEXCEPT;
        nn::Result ReadRawScreenShotReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, std::int64_t offset) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CaptureRawImageRgba32IntoArray(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index) NN_NOEXCEPT;
    nn::Result CaptureRawImageRgba32IntoArrayWithTimeout(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result AttachSharedBufferToCaptureModule(nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT;
    nn::Result CaptureRawImageToAttachedSharedBuffer(std::int32_t dstIndex, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result SaveScreenShotEx2ViaAm(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
    nn::Result RequestTakingScreenShotEx1(std::uint64_t seqNo, nn::ncm::ProgramId programId, nn::applet::AppletResourceUserId aruid, nn::TimeSpan timeout, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList) NN_NOEXCEPT;
    nn::Result CancelTakingScreenShot(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;
    nn::Result SetTakingScreenShotCancelState(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;
    nn::Result NotifyTakingScreenShotRefused(nn::ncm::ProgramId programId) NN_NOEXCEPT;
    nn::Result NotifyTakingScreenShotFailed(nn::ncm::ProgramId programId) NN_NOEXCEPT;
    nn::Result SetupOverlayMovieThumbnail(const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
    nn::Result CreateProtoMovieMetaDataNv12Ex2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT;
    nn::Result CreateProtoMovieMetaDataRgbaEx2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::InBuffer& imageRgba, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT;
    nn::Result OpenRawScreenShotReadStream(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT;
    nn::Result CloseRawScreenShotReadStream() NN_NOEXCEPT;
    nn::Result ReadRawScreenShotReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, std::int64_t offset) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IScreenShotControlService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArray, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CaptureRawImageRgba32IntoArray, (pOutBuffer, layerStack, width, height, length, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArrayWithTimeout, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index, ::nn::TimeSpan timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CaptureRawImageRgba32IntoArrayWithTimeout, (pOutBuffer, layerStack, width, height, length, index, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachSharedBufferToCaptureModule, (::nn::vi::fbshare::SharedBufferHandle hBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachSharedBufferToCaptureModule, (hBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageToAttachedSharedBuffer, (::std::int32_t dstIndex, ::std::int32_t layerStack, ::nn::TimeSpan timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CaptureRawImageToAttachedSharedBuffer, (dstIndex, layerStack, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx2ViaAm, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShotEx2ViaAm, (outEntry, imageBuffer, attribute, userIdList, aruid, overlayRequest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestTakingScreenShotEx1, (::std::uint64_t seqNo, ::nn::ncm::ProgramId programId, ::nn::applet::AppletResourceUserId aruid, ::nn::TimeSpan timeout, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestTakingScreenShotEx1, (seqNo, programId, aruid, timeout, attribute, userIdList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelTakingScreenShot, (::std::uint64_t seqNo, ::nn::Result reason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelTakingScreenShot, (seqNo, reason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTakingScreenShotCancelState, (::std::uint64_t seqNo, ::nn::Result reason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTakingScreenShotCancelState, (seqNo, reason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotRefused, (::nn::ncm::ProgramId programId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyTakingScreenShotRefused, (programId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotFailed, (::nn::ncm::ProgramId programId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyTakingScreenShotFailed, (programId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetupOverlayMovieThumbnail, (const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetupOverlayMovieThumbnail, (imageY, imageUv, width, height, fileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataNv12Ex2, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateProtoMovieMetaDataNv12Ex2, (outSize, outMakerNoteOffset, outMakerNoteSize, outMeta, imageY, imageUv, width, height, fileId, attribute, appletData, applicationData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataRgbaEx2, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::InBuffer& imageRgba, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateProtoMovieMetaDataRgbaEx2, (outSize, outMakerNoteOffset, outMakerNoteSize, outMeta, imageRgba, width, height, fileId, attribute, appletData, applicationData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenRawScreenShotReadStream, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::std::int32_t layerStack, ::nn::TimeSpan timeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenRawScreenShotReadStream, (outSize, outWidth, outHeight, layerStack, timeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseRawScreenShotReadStream)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseRawScreenShotReadStream);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadRawScreenShotReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadRawScreenShotReadStream, (outReadSize, outBuffer, offset));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IScreenShotControlService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IScreenShotControlService))

    // nn::Result CaptureRawImageRgba32IntoArray(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CaptureRawImageRgba32IntoArray)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerStack, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(length, (::std::int64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (layerStack, width, height, length, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerStack), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(length), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CaptureRawImageRgba32IntoArray)

    // nn::Result CaptureRawImageRgba32IntoArrayWithTimeout(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CaptureRawImageRgba32IntoArrayWithTimeout)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerStack, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(length, (::std::int64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::int64_t), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::TimeSpan), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (layerStack, width, height, length, index, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerStack), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(length), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CaptureRawImageRgba32IntoArrayWithTimeout)

    // nn::Result AttachSharedBufferToCaptureModule(nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachSharedBufferToCaptureModule)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(hBuffer, (::nn::vi::fbshare::SharedBufferHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (hBuffer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachSharedBufferToCaptureModule)

    // nn::Result CaptureRawImageToAttachedSharedBuffer(std::int32_t dstIndex, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CaptureRawImageToAttachedSharedBuffer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstIndex, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerStack, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::TimeSpan), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (dstIndex, layerStack, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerStack), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CaptureRawImageToAttachedSharedBuffer)

    // nn::Result SaveScreenShotEx2ViaAm(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShotEx2ViaAm)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(userIdList, 0, (const ::nn::capsrv::UserIdList&), 136, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (userIdList, imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(overlayRequest, (::nn::capsrv::OverlayNotificationRequestType), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (attribute, overlayRequest, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userIdList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(overlayRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShotEx2ViaAm)

    // nn::Result RequestTakingScreenShotEx1(std::uint64_t seqNo, nn::ncm::ProgramId programId, nn::applet::AppletResourceUserId aruid, nn::TimeSpan timeout, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestTakingScreenShotEx1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(userIdList, 0, (const ::nn::capsrv::UserIdList&), 136, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (userIdList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seqNo, (::std::uint64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 72)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 80)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::TimeSpan), 88)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (attribute, seqNo, programId, aruid, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(96)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seqNo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(userIdList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestTakingScreenShotEx1)

    // nn::Result CancelTakingScreenShot(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelTakingScreenShot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reason, (::nn::Result), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seqNo, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (reason, seqNo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seqNo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelTakingScreenShot)

    // nn::Result SetTakingScreenShotCancelState(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTakingScreenShotCancelState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reason, (::nn::Result), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(seqNo, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (reason, seqNo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(seqNo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTakingScreenShotCancelState)

    // nn::Result NotifyTakingScreenShotRefused(nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyTakingScreenShotRefused)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyTakingScreenShotRefused)

    // nn::Result NotifyTakingScreenShotFailed(nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyTakingScreenShotFailed)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1012)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyTakingScreenShotFailed)

    // nn::Result SetupOverlayMovieThumbnail(const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetupOverlayMovieThumbnail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageY, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageUv, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (imageY, imageUv))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (width, height, fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageY), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageUv), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetupOverlayMovieThumbnail)

    // nn::Result CreateProtoMovieMetaDataNv12Ex2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateProtoMovieMetaDataNv12Ex2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1106)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(appletData, 0, (const ::nn::capsrv::AppletData&), 1024, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(applicationData, 1, (const ::nn::capsrv::ApplicationData&), 1028, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outMeta, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageY, 3, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageUv, 4, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(5, (appletData, applicationData, outMeta, imageY, imageUv))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 72)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (attribute, width, height, fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(104)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMakerNoteOffset, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMakerNoteSize, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outSize, outMakerNoteOffset, outMakerNoteSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMakerNoteOffset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMakerNoteSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMeta), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageY), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageUv), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateProtoMovieMetaDataNv12Ex2)

    // nn::Result CreateProtoMovieMetaDataRgbaEx2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::InBuffer& imageRgba, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateProtoMovieMetaDataRgbaEx2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1107)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(appletData, 0, (const ::nn::capsrv::AppletData&), 1024, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(applicationData, 1, (const ::nn::capsrv::ApplicationData&), 1028, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outMeta, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageRgba, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (appletData, applicationData, outMeta, imageRgba))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::std::int64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(height, (::std::int64_t), 72)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(fileId, (::nn::capsrv::AlbumFileId), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (attribute, width, height, fileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(104)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMakerNoteOffset, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMakerNoteSize, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outSize, outMakerNoteOffset, outMakerNoteSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMakerNoteOffset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMakerNoteSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMeta), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageRgba), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(height), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(fileId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateProtoMovieMetaDataRgbaEx2)

    // nn::Result OpenRawScreenShotReadStream(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenRawScreenShotReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(layerStack, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(timeout, (::nn::TimeSpan), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (layerStack, timeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outWidth, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHeight, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outSize, outWidth, outHeight))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(layerStack), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(timeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenRawScreenShotReadStream)

    // nn::Result CloseRawScreenShotReadStream() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseRawScreenShotReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseRawScreenShotReadStream)

    // nn::Result ReadRawScreenShotReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, std::int64_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadRawScreenShotReadStream)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReadSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outReadSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadRawScreenShotReadStream)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::TimeSpan), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::vi::fbshare::SharedBufferHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::UserIdList), 136, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::OverlayNotificationRequestType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::Result), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AppletData), 1024, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationData), 1028, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IScreenShotControlService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IScreenShotControlService))

    // nn::Result CaptureRawImageRgba32IntoArray(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArray, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CaptureRawImageRgba32IntoArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(length)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CaptureRawImageRgba32IntoArray)
    }

    // nn::Result CaptureRawImageRgba32IntoArrayWithTimeout(const nn::sf::OutBuffer& pOutBuffer, std::int32_t layerStack, std::int64_t width, std::int64_t height, std::int64_t length, std::int64_t index, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageRgba32IntoArrayWithTimeout, (const ::nn::sf::OutBuffer& pOutBuffer, ::std::int32_t layerStack, ::std::int64_t width, ::std::int64_t height, ::std::int64_t length, ::std::int64_t index, ::nn::TimeSpan timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CaptureRawImageRgba32IntoArrayWithTimeout)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(length)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CaptureRawImageRgba32IntoArrayWithTimeout)
    }

    // nn::Result AttachSharedBufferToCaptureModule(nn::vi::fbshare::SharedBufferHandle hBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachSharedBufferToCaptureModule, (::nn::vi::fbshare::SharedBufferHandle hBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachSharedBufferToCaptureModule)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachSharedBufferToCaptureModule)
    }

    // nn::Result CaptureRawImageToAttachedSharedBuffer(std::int32_t dstIndex, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CaptureRawImageToAttachedSharedBuffer, (::std::int32_t dstIndex, ::std::int32_t layerStack, ::nn::TimeSpan timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CaptureRawImageToAttachedSharedBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CaptureRawImageToAttachedSharedBuffer)
    }

    // nn::Result SaveScreenShotEx2ViaAm(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx2ViaAm, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShotEx2ViaAm)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userIdList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(overlayRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShotEx2ViaAm)
    }

    // nn::Result RequestTakingScreenShotEx1(std::uint64_t seqNo, nn::ncm::ProgramId programId, nn::applet::AppletResourceUserId aruid, nn::TimeSpan timeout, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::UserIdList& userIdList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestTakingScreenShotEx1, (::std::uint64_t seqNo, ::nn::ncm::ProgramId programId, ::nn::applet::AppletResourceUserId aruid, ::nn::TimeSpan timeout, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::UserIdList& userIdList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestTakingScreenShotEx1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seqNo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(userIdList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestTakingScreenShotEx1)
    }

    // nn::Result CancelTakingScreenShot(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelTakingScreenShot, (::std::uint64_t seqNo, ::nn::Result reason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelTakingScreenShot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seqNo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelTakingScreenShot)
    }

    // nn::Result SetTakingScreenShotCancelState(std::uint64_t seqNo, nn::Result reason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTakingScreenShotCancelState, (::std::uint64_t seqNo, ::nn::Result reason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTakingScreenShotCancelState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(seqNo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTakingScreenShotCancelState)
    }

    // nn::Result NotifyTakingScreenShotRefused(nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotRefused, (::nn::ncm::ProgramId programId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyTakingScreenShotRefused)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyTakingScreenShotRefused)
    }

    // nn::Result NotifyTakingScreenShotFailed(nn::ncm::ProgramId programId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyTakingScreenShotFailed, (::nn::ncm::ProgramId programId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyTakingScreenShotFailed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyTakingScreenShotFailed)
    }

    // nn::Result SetupOverlayMovieThumbnail(const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetupOverlayMovieThumbnail, (const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetupOverlayMovieThumbnail)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageY)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageUv)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetupOverlayMovieThumbnail)
    }

    // nn::Result CreateProtoMovieMetaDataNv12Ex2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::OutBuffer& imageY, const nn::sf::OutBuffer& imageUv, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataNv12Ex2, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::OutBuffer& imageY, const ::nn::sf::OutBuffer& imageUv, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateProtoMovieMetaDataNv12Ex2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMakerNoteOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMakerNoteSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageY)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageUv)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateProtoMovieMetaDataNv12Ex2)
    }

    // nn::Result CreateProtoMovieMetaDataRgbaEx2(nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<std::int64_t> outMakerNoteOffset, nn::sf::Out<std::int64_t> outMakerNoteSize, const nn::sf::OutBuffer& outMeta, const nn::sf::InBuffer& imageRgba, std::int64_t width, std::int64_t height, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::ApplicationData& applicationData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateProtoMovieMetaDataRgbaEx2, (::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::std::int64_t> outMakerNoteOffset, ::nn::sf::Out<::std::int64_t> outMakerNoteSize, const ::nn::sf::OutBuffer& outMeta, const ::nn::sf::InBuffer& imageRgba, ::std::int64_t width, ::std::int64_t height, const ::nn::capsrv::AlbumFileId& fileId, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::ApplicationData& applicationData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateProtoMovieMetaDataRgbaEx2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMakerNoteOffset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMakerNoteSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageRgba)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(height)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(fileId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateProtoMovieMetaDataRgbaEx2)
    }

    // nn::Result OpenRawScreenShotReadStream(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outWidth, nn::sf::Out<std::int64_t> outHeight, std::int32_t layerStack, nn::TimeSpan timeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenRawScreenShotReadStream, (::nn::sf::Out<::std::int64_t> outSize, ::nn::sf::Out<::std::int64_t> outWidth, ::nn::sf::Out<::std::int64_t> outHeight, ::std::int32_t layerStack, ::nn::TimeSpan timeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenRawScreenShotReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(layerStack)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(timeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenRawScreenShotReadStream)
    }

    // nn::Result CloseRawScreenShotReadStream() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseRawScreenShotReadStream)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseRawScreenShotReadStream)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseRawScreenShotReadStream)
    }

    // nn::Result ReadRawScreenShotReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, std::int64_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadRawScreenShotReadStream, (::nn::sf::Out<::std::int64_t> outReadSize, const ::nn::sf::OutBuffer& outBuffer, ::std::int64_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadRawScreenShotReadStream)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadRawScreenShotReadStream)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IScreenShotControlService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IScreenShotControlService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CaptureRawImageRgba32IntoArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CaptureRawImageRgba32IntoArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerStack),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(length),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CaptureRawImageRgba32IntoArrayWithTimeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CaptureRawImageRgba32IntoArrayWithTimeout)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerStack),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(length),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachSharedBufferToCaptureModule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachSharedBufferToCaptureModule)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(hBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CaptureRawImageToAttachedSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CaptureRawImageToAttachedSharedBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerStack),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShotEx2ViaAm)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userIdList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShotEx2ViaAm)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userIdList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(overlayRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestTakingScreenShotEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(userIdList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestTakingScreenShotEx1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seqNo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(userIdList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelTakingScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelTakingScreenShot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seqNo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTakingScreenShotCancelState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTakingScreenShotCancelState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(seqNo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyTakingScreenShotRefused)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyTakingScreenShotRefused)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyTakingScreenShotFailed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyTakingScreenShotFailed)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetupOverlayMovieThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageY)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageUv)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetupOverlayMovieThumbnail)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageY),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageUv),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateProtoMovieMetaDataNv12Ex2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appletData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(applicationData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outMeta)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageY)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageUv)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateProtoMovieMetaDataNv12Ex2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMakerNoteOffset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMakerNoteSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outMeta),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageY),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageUv),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appletData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(applicationData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateProtoMovieMetaDataRgbaEx2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appletData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(applicationData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outMeta)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageRgba)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateProtoMovieMetaDataRgbaEx2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMakerNoteOffset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMakerNoteSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outMeta),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageRgba),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(height),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(fileId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appletData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(applicationData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenRawScreenShotReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenRawScreenShotReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(layerStack),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(timeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseRawScreenShotReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseRawScreenShotReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadRawScreenShotReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadRawScreenShotReadStream)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReadSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CaptureRawImageRgba32IntoArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CaptureRawImageRgba32IntoArrayWithTimeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachSharedBufferToCaptureModule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CaptureRawImageToAttachedSharedBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShotEx2ViaAm)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestTakingScreenShotEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelTakingScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTakingScreenShotCancelState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyTakingScreenShotRefused)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyTakingScreenShotFailed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetupOverlayMovieThumbnail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateProtoMovieMetaDataNv12Ex2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateProtoMovieMetaDataRgbaEx2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenRawScreenShotReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseRawScreenShotReadStream)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadRawScreenShotReadStream)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IScreenShotControlService))

namespace nn { namespace capsrv { namespace sf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IScreenShotService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IScreenShotService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShot, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShot, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::AlbumFileId& originalFileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx0, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AlbumFileId& originalFileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx1, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotOfMovieEx1, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IScreenShotService)

        ::nn::Result SaveScreenShot(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShot, (outEntry, imageBuffer, size, aruid, overlayRequest));
        }

        ::nn::Result SaveEditedScreenShot(::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveEditedScreenShot, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, originalFileId));
        }

        ::nn::Result SaveScreenShotEx0(::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (outEntry, imageBuffer, attribute, aruid, overlayRequest));
        }

        ::nn::Result SaveEditedScreenShotEx0(::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx0, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, attribute, originalFileId));
        }

        ::nn::Result SaveEditedScreenShotEx1(::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx1, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, attribute, appletData, originalFileId));
        }

        ::nn::Result SaveScreenShotOfMovieEx1(::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SaveScreenShotOfMovieEx1, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, attribute, appletData, originalFileId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IScreenShotService
    {
    public:
        nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result SaveEditedScreenShot(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result SaveEditedScreenShotEx0(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
        nn::Result SaveEditedScreenShotEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
        nn::Result SaveScreenShotOfMovieEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
    nn::Result SaveEditedScreenShot(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
    nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
    nn::Result SaveEditedScreenShotEx0(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
    nn::Result SaveEditedScreenShotEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
    nn::Result SaveScreenShotOfMovieEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::capsrv::sf::IScreenShotService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShot, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShot, (outEntry, imageBuffer, size, aruid, overlayRequest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShot, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveEditedScreenShot, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, originalFileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShotEx0, (outEntry, imageBuffer, attribute, aruid, overlayRequest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx0, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveEditedScreenShotEx0, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, attribute, originalFileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx1, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveEditedScreenShotEx1, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, attribute, appletData, originalFileId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotOfMovieEx1, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SaveScreenShotOfMovieEx1, (outFileEntry, imageBuffer, thumbnailBuffer, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, attribute, appletData, originalFileId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::capsrv::sf::IScreenShotService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::capsrv::sf::IScreenShotService))

    // nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::nn::capsrv::ScreenShotSizeType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(overlayRequest, (::nn::capsrv::OverlayNotificationRequestType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (size, overlayRequest, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(overlayRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShot)

    // nn::Result SaveEditedScreenShot(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveEditedScreenShot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbnailBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (imageBuffer, thumbnailBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageWidth, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageHeight, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailWidth, (::std::int64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailHeight, (::std::int64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(originalFileId, (::nn::capsrv::AlbumFileId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, originalFileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileEntry, (::nn::capsrv::AlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFileEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(originalFileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveEditedScreenShot)

    // nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShotEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (imageBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(overlayRequest, (::nn::capsrv::OverlayNotificationRequestType), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (attribute, overlayRequest, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outEntry, (::nn::capsrv::ApplicationAlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(overlayRequest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShotEx0)

    // nn::Result SaveEditedScreenShotEx0(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveEditedScreenShotEx0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbnailBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (imageBuffer, thumbnailBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageWidth, (::std::int64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageHeight, (::std::int64_t), 72)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailWidth, (::std::int64_t), 80)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailHeight, (::std::int64_t), 88)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(originalFileId, (::nn::capsrv::AlbumFileId), 96)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (attribute, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, originalFileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(120)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileEntry, (::nn::capsrv::AlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFileEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(originalFileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveEditedScreenShotEx0)

    // nn::Result SaveEditedScreenShotEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveEditedScreenShotEx1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(appletData, 0, (const ::nn::capsrv::AppletData&), 1024, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbnailBuffer, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (appletData, imageBuffer, thumbnailBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageWidth, (::std::int64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageHeight, (::std::int64_t), 72)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailWidth, (::std::int64_t), 80)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailHeight, (::std::int64_t), 88)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(originalFileId, (::nn::capsrv::AlbumFileId), 96)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (attribute, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, originalFileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(120)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileEntry, (::nn::capsrv::AlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFileEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(originalFileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveEditedScreenShotEx1)

    // nn::Result SaveScreenShotOfMovieEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SaveScreenShotOfMovieEx1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(appletData, 0, (const ::nn::capsrv::AppletData&), 1024, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(imageBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(thumbnailBuffer, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (appletData, imageBuffer, thumbnailBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attribute, (::nn::capsrv::detail::ScreenShotAttributeEx0), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageWidth, (::std::int64_t), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageHeight, (::std::int64_t), 72)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailWidth, (::std::int64_t), 80)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thumbnailHeight, (::std::int64_t), 88)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(originalFileId, (::nn::capsrv::AlbumFileId), 96)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (attribute, imageWidth, imageHeight, thumbnailWidth, thumbnailHeight, originalFileId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(120)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFileEntry, (::nn::capsrv::AlbumEntry), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outFileEntry))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFileEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailWidth), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thumbnailHeight), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attribute), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(originalFileId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SaveScreenShotOfMovieEx1)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ApplicationAlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::ScreenShotSizeType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::OverlayNotificationRequestType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumEntry), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AlbumFileId), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::detail::ScreenShotAttributeEx0), 64, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::capsrv::AppletData), 1024, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::capsrv::sf::IScreenShotService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::capsrv::sf::IScreenShotService))

    // nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShot, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, ::nn::capsrv::ScreenShotSizeType size, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(overlayRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShot)
    }

    // nn::Result SaveEditedScreenShot(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShot, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveEditedScreenShot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(originalFileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveEditedScreenShot)
    }

    // nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotEx0, (::nn::sf::Out<::nn::capsrv::ApplicationAlbumEntry> outEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, ::nn::applet::AppletResourceUserId aruid, ::nn::capsrv::OverlayNotificationRequestType overlayRequest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShotEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(overlayRequest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShotEx0)
    }

    // nn::Result SaveEditedScreenShotEx0(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx0, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveEditedScreenShotEx0)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(originalFileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveEditedScreenShotEx0)
    }

    // nn::Result SaveEditedScreenShotEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveEditedScreenShotEx1, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveEditedScreenShotEx1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(originalFileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveEditedScreenShotEx1)
    }

    // nn::Result SaveScreenShotOfMovieEx1(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const nn::capsrv::AppletData& appletData, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SaveScreenShotOfMovieEx1, (::nn::sf::Out<::nn::capsrv::AlbumEntry> outFileEntry, const ::nn::sf::InBuffer& imageBuffer, const ::nn::sf::InBuffer& thumbnailBuffer, ::std::int64_t imageWidth, ::std::int64_t imageHeight, ::std::int64_t thumbnailWidth, ::std::int64_t thumbnailHeight, const ::nn::capsrv::detail::ScreenShotAttributeEx0& attribute, const ::nn::capsrv::AppletData& appletData, const ::nn::capsrv::AlbumFileId& originalFileId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SaveScreenShotOfMovieEx1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFileEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailWidth)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thumbnailHeight)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attribute)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(originalFileId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SaveScreenShotOfMovieEx1)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::capsrv::sf::IScreenShotService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::capsrv::sf::IScreenShotService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(overlayRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveEditedScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbnailBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveEditedScreenShot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbnailBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(originalFileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShotEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShotEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(overlayRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveEditedScreenShotEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbnailBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveEditedScreenShotEx0)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbnailBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(originalFileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveEditedScreenShotEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appletData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbnailBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveEditedScreenShotEx1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbnailBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appletData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(originalFileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SaveScreenShotOfMovieEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appletData)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(imageBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(thumbnailBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SaveScreenShotOfMovieEx1)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFileEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(imageBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(thumbnailBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailWidth),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thumbnailHeight),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attribute),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appletData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(originalFileId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveEditedScreenShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShotEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveEditedScreenShotEx0)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveEditedScreenShotEx1)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SaveScreenShotOfMovieEx1)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::capsrv::sf::IScreenShotService))
