﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include "capsrv_MovieConfig.h"

namespace nn{ namespace capsrv{ namespace movie{

        struct MovieFilePath
        {
        public:
            static MovieFilePath FromString(const char* str) NN_NOEXCEPT;

            bool operator==(const MovieFilePath& v) const NN_NOEXCEPT;
            bool operator!=(const MovieFilePath& v) const NN_NOEXCEPT;
        public:
            // <MOUNT>:/<filename>\0
            char value[nn::fs::MountNameLengthMax + 2 + MovieFilenameLengthMax + 1];
        };

}}}
