﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Enum.h>

namespace nn{ namespace capsrv{

    //! @brief オーバーレイ通知時のサムネイル画像の大きさです。
    enum ThumbnailImageSize
    {
        //! @brief オーバーレイ通知時のサムネイル画像の幅（ピクセル）です。
        ThumbnailImageSize_Width  = 96,

        //! @brief オーバーレイ通知時のサムネイル画像の高さ（ピクセル）です。
        ThumbnailImageSize_Height = 54,
    };

    //! @brief サムネイル画像のフォーマットです。
    enum ThumbnailImageFormat
    {
        //! @brief 既定のサムネイル画像のフォーマットです。
        //! @details
        //! 1 ピクセルあたり 4 バイトです。
        ThumbnailImageFormat_Default = nn::gfx::ImageFormat_R8_G8_B8_A8_Unorm,
    };

    //! @brief オーバーレイ通知時のサムネイル画像のデータサイズです。
    enum ThumbnailImageDataSize
    {
        //! @brief 既定のサムネイル画像のデータサイズ（バイト）です。
        ThumbnailImageDataSize_Default = 4 * ThumbnailImageSize_Width * ThumbnailImageSize_Height,
    };

}}
