﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{

    //! @brief 画面写真の JPEG デコーダに指定するオプションのフラグです。
    enum ScreenShotJpegDecoderFlag
    {
        //! @brief JPEG デコーダのオプションを指定しません（既定値）
        ScreenShotJpegDecoderFlag_None = 0,

        //! @brief JPEG デコーダの FancyUpsampling を有効にします。
        ScreenShotJpegDecoderFlag_EnableFancyUpsampling = (1 << 0),

        //! @brief JPEG デコーダの BlockSmoothing を有効にします。
        ScreenShotJpegDecoderFlag_EnableBlockSmoothing  = (1 << 1),
    };

    //! @brief 画面写真の JPEG デコーダに指定するオプションのフラグの型です。
    typedef uint64_t ScreenShotJpegDecoderFlagType;

    //! @brief 画面写真のデコードオプションです。
    struct ScreenShotDecodeOption
    {
    public:
        //! @brief 既定値を取得します。
        //! @details
        //! 既定値は以下の値が設定されます。
        //! - jpegDecoderFlag == ScreenShotJpegDecoderFlag_None
        static ScreenShotDecodeOption GetDefaultValue() NN_NOEXCEPT
        {
            ScreenShotDecodeOption option = {};
            return option;
        }

    public:
        //! @brief JPEG デコーダのオプションに指定したフラグが設定されているかを検査します。
        //! @param[in] flag 検査するフラグ
        //! @details
        //! flag に複数のフラグを指定した場合、いずれか 1 つが設定されていれば true を返します。
        bool HasJpegDecoderFlag(ScreenShotJpegDecoderFlagType flag) const NN_NOEXCEPT
        {
            return (this->jpegDecoderFlag & flag) != 0;
        }

    public:

        //! @brief 画面写真の JPEG デコーダに指定するオプションのフラグ
        ScreenShotJpegDecoderFlagType jpegDecoderFlag;

        char _reserved[24];
    };

}}
