﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace capsrv{

    //! @brief アルバムのストレージを示す変数の型です。
    typedef std::uint8_t AlbumStorageType;

    //! @brief アルバムのストレージを示す値です。
    enum AlbumStorage
    {

        //! @brief NAND 上のアルバムです。
        AlbumStorage_Nand,

        //! @brief SD カード上のアルバムです。
        AlbumStorage_Sd,
    };

    //! @brief アルバムのストレージを示す値の数です。
    static const int AlbumStorageCount = 2;

}}
