﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "album_CommonApi.h"
#include "album_ShareId.h"

namespace nn{ namespace album{

    //! @brief 投稿ページの最終 URL を受け取るために十分なバッファのサイズ（バイト）です。
    static const int SharePostedLastUrlSizeMax = 512;

    //! @brief 投稿ページの最終 URL を取得します。
    //! @param[out] pOutBuffer 文字列を受け取るバッファです。
    //! @param[in]  bufferSize pOutBuffer の大きさ（バイト）です。
    //! @param[in]  shareId    投稿 ID です。
    //! @pre アルバムライブラリが使用可能
    //! @pre pOutBuffer != nullptr
    //! @pre bufferSize > 0
    //! @return バッファに書き込んだ文字数（終端文字を含まない）
    //! @details
    //! 投稿ページの最終 URL を ShareId から取得します。取得される文字列はヌル終端されます。
    //! 文字列がバッファに収まりきらない場合、先頭から bufferSize - 1 文字をバッファに書き込みます。
    //! 書き込んだ文字数（終端文字を含まない）を返します。
    //!
    //! 文字列全体を受け取るために十分なバッファのサイズは SharePostedLastUrlSizeMax （終端文字を含む）です。
    //!
    //! この API で取得される URL のフォーマットは将来的に変更される可能性があり、互換性が保証されません。
    //! このため、 URL をアプリケーション内で独自に解析することは禁止されています。
    //! 投稿先のサービスや投稿したエントリーの識別子が必要な場合、 GetSharePostedServiceName() や GetSharePostedEntryId() を使用して値を取得してください。
    //!
    //! 投稿先情報が取得できなかった場合、バッファに空文字列を書き込み、 0 を返します。
    int GetSharePostedLastUrl(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT;

}}
