﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/album/album_AlbumFileEntry.h>
#include <nn/time/time_CalendarTime.h>

namespace nn { namespace album {

//! @brief アルバム内のファイル識別子の構造体です。
//! @details
//! この識別子は単純コピー可能であり、バイナリ比較で同一性の判定が可能です。
//!
struct NN_ALIGNAS(8) AlbumFileEntry
{
    char _encrypted[48];
};
NN_STATIC_ASSERT(sizeof(AlbumFileEntry) == 48);


//! @brief ファイルの作成日時を返します。
//!
//! @param[in] albumFileEntry  対象とするファイル識別子
//! @return ファイルの作成日時を返す
//!
//! @details
//! 指定された AlbumFileEntry が示すアルバム内のファイルにおいて、
//! そのファイル作成日時を nn::time::CalendarTime 型で返します。
//!
nn::time::CalendarTime GetAlbumFileCreatedTime(const AlbumFileEntry& albumFileEntry) NN_NOEXCEPT;


}}  // namespace nn::album
