﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifdef TMUTILITY_EXPORTS
#define TMUTILITY_API extern "C" __declspec(dllexport)
#else
#define TMUTILITY_API extern "C" __declspec(dllimport)
#endif

#include <cstring>
#include <autoTestAssistTool/TmUtilityTypes.h>
#include <autoTestAssistTool/Common/autoTestAssistTool_LibTypes.h>

/**
*   @file
*   @brief  TM ライブラリのユーティリティ API
*/


/**
* @brief        TargetManager に接続されている開発機の数を取得します。
*
* @param[out]   pOutCount       接続されている開発機の数
*
* @return       結果を返します
* @retval       TmUtilityResult_Success            成功しました。
* @retval       TmUtilityResult_ConnectFailed      TargetManager への接続に失敗しました。
*/
TMUTILITY_API TmUtilityResult GetConnectedTargetCount(int* pOutCount);

/**
* @brief        TargetManager に接続されている開発機のシリアル番号一覧を取得します。
*
* @param[out]   outSerialNumberArray    接続されている開発機のシリアル番号を格納する配列
* @param[in]    serialNumberArrayCount  outSerialNumberArray の配列の要素数
*
* @return       結果を返します
* @retval       TmUtilityResult_Success            成功しました。
* @retval       TmUtilityResult_ConnectFailed      TargetManager への接続に失敗しました。
*
* @details      serialNumbersCount より多くの機材が接続されている場合は serialNumbersCount の数だけ取得します。
*/
TMUTILITY_API TmUtilityResult GetConnectedTargetSerialNumbers(
    SerialNumberString outSerialNumberArray[], int serialNumberArrayCount);
