﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SettingsManager
{
    /// <summary>
    /// エラーコードを定義します。
    /// </summary>
    internal enum ErrorCode
    {
        /// <summary>
        /// エラーは発生しませんでした
        /// </summary>
        None,

        /// <summary>
        /// コマンドが指定されませんでした
        /// </summary>
        CommandSpecificationMissing = 100,

        /// <summary>
        /// コマンドが見つかりませんでした
        /// </summary>
        CommandNotFound,

        /// <summary>
        /// サポートされないコマンドでした
        /// </summary>
        CommandNotSupported,

        /// <summary>
        /// 不正なリセット方式が指定されました
        /// </summary>
        CommandResetModeInvalid,

        /// <summary>
        /// ファイルが指定されませんでした
        /// </summary>
        FileSpecificationMissing = 200,

        /// <summary>
        /// ファイルのオープンに失敗しました
        /// </summary>
        FileOpenFailure,

        /// <summary>
        /// ファイルサイズの変更に失敗しました
        /// </summary>
        FileSizeChangeFailure,

        /// <summary>
        /// ファイルサイズの取得に失敗しました
        /// </summary>
        FileSizeAcquisitionFailure,

        /// <summary>
        /// ファイルの読み込みに失敗しました
        /// </summary>
        FileReadingFailure,

        /// <summary>
        /// ファイルの書き込みに失敗しました
        /// </summary>
        FileWritingFailure,

        /// <summary>
        /// ファイルのフラッシュに失敗しました
        /// </summary>
        FileFlushingFailure,

        /// <summary>
        /// ノードのキーが見つかりませんでした
        /// </summary>
        NodeKeyMissing = 300,

        /// <summary>
        /// 不正なノードのキーが指定されました
        /// </summary>
        NodeKeyInvalid,

        /// <summary>
        /// サポートされないノードの型でした
        /// </summary>
        NodeTypeUnsupported = 400,

        /// <summary>
        /// ノードの型が一致しませんでした
        /// </summary>
        NodeTypeMismatch,

        /// <summary>
        /// ノードの型が短すぎる配列でした
        /// </summary>
        NodeTypeShortArray,

        /// <summary>
        /// ノードの値が不正でした
        /// </summary>
        NodeValueInvalid = 500,

        /// <summary>
        /// ノードの値が長過ぎました
        /// </summary>
        NodeValueTooLong,

        /// <summary>
        /// ノードの値が有効範囲を超えました
        /// </summary>
        NodeValueOverLimitation,

        /// <summary>
        /// メモリアロケーションに失敗しました
        /// </summary>
        MemoryAllocationFailure = 1000,

        /// <summary>
        /// データのサイズが不正でした
        /// </summary>
        DataSizeInvalid,

        /// <summary>
        /// JSON のパースに失敗しました
        /// </summary>
        JsonParsingFailure,
    }
}
