﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SettingsManager.Command
{
    using Nintendo.ToolFoundation.CommandLine;
    using Properties;

    /// <summary>
    /// Reset コマンドを提供します。
    /// </summary>
    internal sealed class Reset : ICommand
    {
        private CommonOptions commonArgs = new CommonOptions();

        /// <summary>
        /// コマンドが選択されたか否かを表す値を返します。
        /// </summary>
        public bool IsSelected { get; private set; }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="parser">コマンドラインパーサです。</param>
        public void RegiserWith(DelegateBasedCommandLineParser parser)
        {
            var context = parser
                .AddCommand("Reset", () => this.IsSelected = true)
                .SetDescription(Resources.ResetCommand);

            this.commonArgs.RegiserWith(context);
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        public void Execute()
        {
            var platform = this.commonArgs.Platform;

            var enginePath = ResourceManager.GetEnginePath(platform);

            var executer = new Executer(platform);

            executer.Target = this.commonArgs.Target;

            executer.Ignite(enginePath, new[] { "Reset" });
        }
    }
}
