﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeParentalControlMasterKey
{
    class Program
    {
        private static void PrintUsage()
        {
            string baseName = Path.GetFileName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            Console.WriteLine("Usage: {0} <inquiry-code>", baseName);
            Console.WriteLine("  <inquiry-code>: inquiry code (10-digits)");
        }

        static int Main(string[] args)
        {
            if (args.Length < 1 || (
                args[0] == "-?" || args[0] == "/?" ||
                args[0].ToLower() == "-h" || args[0].ToLower() == "--help"
                ))
            {
                PrintUsage();
                return 0;
            }
            try
            {
                var key = MasterKey.Make(args[0]);
                Console.WriteLine(key);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine("error: {0}", e.Message);
            }
            return 0;
        }
    }
}
