﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;

namespace MakeInitialImage
{
    // このあたりをシリアライズ可能にするところから
    [Serializable()]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct SaveDataInfoHeader
    {
        private UInt64 saveId;
        private Int64 fileSize;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = SizeOfFilePath)]
        private string filePath;

        public static SaveDataInfoHeader Create(string nandFilePath, Int64 fileSize)
        {
            var pathPattern = new Regex("^save/([0-9a-fA-F]{16})/0/(.*)$");
            var matchedPath = pathPattern.Match(nandFilePath.Replace("\\","/"));

            if (!matchedPath.Success)
            {
                throw new Exception($"Invalid file path: {nandFilePath}");
            }

            var id = UInt64.Parse(
                matchedPath.Groups[1].Value,
                System.Globalization.NumberStyles.AllowHexSpecifier);

            var saveFilePath = matchedPath.Groups[2].Value;

            return new SaveDataInfoHeader()
            {
                saveId = id,
                filePath = saveFilePath,
                fileSize = fileSize
            };
        }

        public const int SizeOfFilePath = 48;
    }

    [Serializable()]
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct SavedataPartitionHeader
    {
        public static SavedataPartitionHeader Create(Int32 count)
        {
            return new SavedataPartitionHeader()
            {
                SaveDataCount = count
            };
        }

        public Int32 SaveDataCount { get; set; }
    }
}
