﻿using System.Collections.Generic;
using System.Threading;

namespace Nintendo.Log
{
    class SyncQueue<T> : Queue<T>
    {
        private object locker;

        public SyncQueue()
        {
            locker = new object();
        }

        public new void Enqueue(T item)
        {
            lock (locker)
            {
                base.Enqueue(item);
                Monitor.Pulse(locker);
            }
        }

        public T DequeueSync()
        {
            lock (locker)
            {
                while (!(Count > 0))
                {
                    Monitor.Wait(locker);
                }
                return Dequeue();
            }
        }
    }
}
