﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using System.Threading.Tasks.Dataflow;

namespace Nintendo.Log
{
    internal class LogViewerClientTab : LogViewerTab
    {
        public LogViewerClientTab()
            : this("Log")
        {
        }

        public LogViewerClientTab(string text)
            : base(text)
        {
            this.HandleCreated += (sender, e) =>
            {
                Task.Factory.StartNew(ReceiveFunc);
                Task.Factory.StartNew(() =>
                {
                    UpdateFunc();
                    ReceiveCancellationTokenSource.Cancel(true);
                });
            };
            LogTextBox.VScroll += (sender, e) =>
            {
                if (IsLogTailShown)
                {
                    UpdatePartial();
                }
            };
        }

        private void ReceiveFunc()
        {
            var bufferBlock = new BufferBlock<Dictionary<string, object>>();
            using (LogClient.LinkToLogBroadcastBlock(bufferBlock, log => log.ContainsKey("TextLog")))
            {
                while (true)
                {
                    Dictionary<string, object> log;
                    try
                    {
                        log = bufferBlock.Receive(ReceiveCancellationTokenSource.Token); // ログを受信するまでブロックする
                    }
                    catch (OperationCanceledException)
                    {
                        break;
                    }
                    var receiveCount = bufferBlock.Count + 1; // 最初に受信した +1

                    lock (BackgroundLogBuffer)
                    {
                        var overflowCount = (BackgroundLogBuffer.Count + receiveCount) - BackgroundLogCountMax;
                        if (overflowCount > 0)
                        {
                            BackgroundLogBuffer.RemoveRange(0, overflowCount);
                            BackgroundLogBeginIndex += overflowCount;
                        }

                        BackgroundLogBuffer.Add(log);
                        for (var count = 1; count < receiveCount; count++) // 既にひとつ受信しているため、count は 1 から始める
                        {
                            BackgroundLogBuffer.Add(bufferBlock.Receive());
                        }
                        BackgroundLogEndIndex += receiveCount;
                    }

                    UpdatePartial();
                }
            }
        }
    }
}
