﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading;
using System.Threading.Tasks.Dataflow;

namespace Nintendo.Log
{
    public class LogService : MarshalByRefObject, ILogService
    {
        private LogServer LogServer;
        private Dictionary<int, BufferBlock<Dictionary<string, object>>> LogBufferBlockTable = new Dictionary<int, BufferBlock<Dictionary<string, object>>>();
        private Dictionary<int, CancellationTokenSource> CancellationTokenSourceTable = new Dictionary<int, CancellationTokenSource>();

        public Dictionary<string, object> ReceiveLog(int pid)
        {
            if (!LogBufferBlockTable.ContainsKey(pid))
            {
                // クライアントごとに受信状態を管理するために、個別にバッファブロックを生成する
                LogBufferBlockTable[pid] = LogServer.CreateLogBufferBlock();
                CancellationTokenSourceTable[pid] = new CancellationTokenSource();
            }
            try
            {
                return LogBufferBlockTable[pid].Receive(CancellationTokenSourceTable[pid].Token);
            }
            catch (OperationCanceledException)
            {
                return null;
            }
        }

        public override object InitializeLifetimeService()
        {
            return null; // 時間経過で接続が切れないように、サービスオブジェクトの生存期間を設定しない
        }

        private void PollClientAlive()
        {
            while (true) // TODO: キャンセルによるタスクの終了
            {
                if (LogBufferBlockTable.Count > 0)
                {
                    var alivePidSet = new HashSet<int>(Process.GetProcesses().Select(process => process.Id));
                    var deadPidList = LogBufferBlockTable.Keys.Where(pid => !alivePidSet.Contains(pid)).ToList();
                    foreach (var pid in deadPidList)
                    {
                        CancellationTokenSourceTable[pid].Cancel();
                        CancellationTokenSourceTable.Remove(pid);
                        LogBufferBlockTable[pid].Complete();
                        LogBufferBlockTable.Remove(pid);
                    }
                }
                Thread.Sleep(1000);
            }
        }

        public LogService(LogServer server)
        {
            LogServer = server;
            var thread = new Thread(PollClientAlive);
            thread.Start();
        }
    }
}
