﻿using System;
using System.Diagnostics;
using System.IO;
using System.Threading;
using System.Windows.Forms;

namespace Nintendo.Log
{
    internal class Program
    {
        private static void SetupLogging()
        {
            var listener = new TextWriterTraceListener(Path.ChangeExtension(Process.GetCurrentProcess().MainModule.FileName, "log"));
            listener.TraceOutputOptions = TraceOptions.DateTime | TraceOptions.ProcessId | TraceOptions.ThreadId;
            listener.Filter = new EventTypeFilter(SourceLevels.Warning);
            Trace.Listeners.Add(listener);
            Trace.AutoFlush = true;

            AppDomain.CurrentDomain.UnhandledException += (sender, args) =>
            {
                var exception = (Exception)args.ExceptionObject;
                Trace.TraceError(exception.ToString());
            };
        }

        private static void Run()
        {
            var apllicationName = "Nintendo Log Server";
            var createdNew = false;
            using (var mutex = new Mutex(true, apllicationName, out createdNew))
            {
                if (!createdNew) // 多重起動チェック
                {
                    // FIXME: 既に起動しているアプリのトレイアイコンからバルーンを出したい
                    return;
                }
                Process.GetCurrentProcess().PriorityClass = ProcessPriorityClass.High;
                var window = new LogServerWindow();
                var server = new LogServer("iywys@$LogManager");
                server.Start();
                Application.EnableVisualStyles();
                Application.DoEvents();
                Application.Run(window);
                server.Stop();
            }
        }

        private static void Main(string[] args)
        {
            try
            {
                SetupLogging();
                Run();
            }
            catch (Exception exception)
            {
                MessageBox.Show(
                    "Nintendo Log Server is terminated abnormally." + Environment.NewLine + Environment.NewLine + exception.ToString());
            }
        }
    }
}
