﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace Nintendo.HtcTools.Htclow
{
    internal class PacketFactory
    {
        public const ushort MaxVersion = 1;

        private ushort m_Version = MaxVersion;
        public ushort Version
        {
            get
            {
                return m_Version;
            }
            set
            {
                if (value > MaxVersion)
                {
                    throw new ArgumentException($"Version {value} is not supported.");
                }
                m_Version = value;
            }
        }

        public Packet MakeSynPacket(Channel channel)
        {
            return new Packet()
            {
                Version = m_Version,
                PacketType = PacketType.Syn,
                Channel = channel,
                SequenceId = 0,
            };
        }

        public Packet MakeSynAckPacket(Channel channel)
        {
            return new Packet()
            {
                Version = m_Version,
                PacketType = PacketType.SynAck,
                Channel = channel,
                SequenceId = 0,
            };
        }

        public Packet MakeDataPacket(Channel channel, byte[] body)
        {
            return MakeDataPacket(channel, body, 0);
        }

        public Packet MakeDataPacket(Channel channel, byte[] body, int bodyOffset, int bodySize)
        {
            return MakeDataPacket(channel, body, bodyOffset, bodySize, 0);
        }

        public Packet MakeDataPacket(Channel channel, byte[] body, long sequenceId)
        {
            return MakeDataPacket(channel, body, 0, body.Length, sequenceId);
        }

        public Packet MakeDataPacket(Channel channel, byte[] body, int bodyOffset, int bodySize, long sequenceId)
        {
            var packet = new Packet(bodySize)
            {
                Version = m_Version,
                PacketType = PacketType.Data,
                Channel = channel,
                SequenceId = sequenceId,
            };
            packet.SetBody(body, bodyOffset, bodySize);
            return packet;
        }

        public Packet MakeDataAckPacket(Channel channel, long sequenceId)
        {
            return new Packet()
            {
                Version = m_Version,
                PacketType = PacketType.DataAck,
                Channel = channel,
                SequenceId = sequenceId,
            };
        }

        public Packet MakeFinPacket(Channel channel)
        {
            return new Packet()
            {
                Version = m_Version,
                PacketType = PacketType.Fin,
                Channel = channel,
                SequenceId = 0,
            };
        }

        public Packet MakeFinAckPacket(Channel channel, long sequenceId)
        {
            return new Packet()
            {
                Version = m_Version,
                PacketType = PacketType.FinAck,
                Channel = channel,
                SequenceId = sequenceId,
            };
        }
    }
}
