﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.HtcTools
{
    /// <summary>
    /// Htclow 層の例外です。
    /// この例外が発生した場合、すべてのチャンネルで通信が続行不能になります。
    /// </summary>
    [Serializable]
    public class HtclowException : Exception
    {
        internal HtclowException(string message)
            : base(message)
        {
        }
    }

    /// <summary>
    /// Htclow の特定のチャンネルでエラーが発生したことを示す例外です。
    /// 他のチャンネルへの影響はありません。
    /// </summary>
    [Serializable]
    public class HtclowChannelException : Exception
    {
        public byte ModuleId { get; private set; }
        public ushort ChannelId { get; private set; }

        internal HtclowChannelException(Htclow.Channel channel, string message)
            : base(message)
        {
            ModuleId = channel.ModuleId;
            ChannelId = channel.ChannelId;
        }

        public override void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            base.GetObjectData(info, context);
            info.AddValue("ModuleId", ModuleId);
            info.AddValue("ChannelId", ChannelId);
        }
    }
}
