﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace Nintendo.HtcTools.HtcfsLibrary
{
    internal class DirectoryEntryTable<T> : IDisposable
        where T : IDisposable
    {
        // dictionaries (key: handle)
        private IDictionary<int, T> entries = new Dictionary<int, T>();
        private IDictionary<int, int> priorities = new Dictionary<int, int>();

        public T this[int handle]
        {
            get
            {
                return entries[handle];
            }
            set
            {
                entries[handle] = value;
            }
        }

        public ICollection<int> Handles
        {
            get
            {
                return entries.Keys;
            }
        }

        public void Add(int handle, T entry)
        {
            entries.Add(handle, entry);
            priorities.Add(handle, 0);
        }

        public void Remove(int handle)
        {
            entries[handle].Dispose();
            entries.Remove(handle);
            priorities.Remove(handle);
        }

        public int GetPriority(int handle)
        {
            return priorities[handle];
        }

        public void SetPriority(int handle, int priority)
        {
            priorities[handle] = priority;
        }

        #region dispose
        private bool disposed = false;

        protected virtual void Dispose(bool disposing)
        {
            if (disposed)
            {
                return;
            }

            foreach (var entry in entries.Values)
            {
                entry.Dispose();
            }
            entries.Clear();

            disposed = true;
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        #endregion
    }
}
