﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "OpusInfo.h"
#include "OpusBasicInfo.h"

namespace Nintendo {
namespace CodecTool {

OpusBasicInfo::OpusBasicInfo()
{
    type = OpusHeaderType_BasicInfo;
    size = 24;  // sizeof(OpusBasicInfo) - 8
    version = 0;
    channelCount = 0;
    frameDataSize = 0;
    sampleRate = 0;
    dataInfoOffset = 0;
    frameDataOffsetInfoOffset = 0;
    contextInfoOffset = 0;
    preskipSampleCount = 0;
    padding2 = 0;
}

void OpusBasicInfo::WriteHeader(System::IO::BinaryWriter^ writer)
{
    writer->Write(type);
    writer->Write(size);
    writer->Write(version);
    writer->Write(channelCount);
    writer->Write(frameDataSize);
    writer->Write(sampleRate);
    writer->Write(dataInfoOffset);
    writer->Write(frameDataOffsetInfoOffset);
    writer->Write(contextInfoOffset);
    writer->Write(preskipSampleCount);
    writer->Write(padding2);
}

}  // namespace CodecTool
}  // namespace Nintendo
