﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public static class Utilities
    {
        public static TParamVm CreateExpandablePathVm<TParamVm>(
            Project project,
            ExpandablePath observablePath,
            Func<ReactiveProperty<string>, TParamVm> paramVmFactory,
            Func<string, string> validator,
            ICollection<IDisposable> disposables) where TParamVm : ParamVm
        {
            var filePathRp = observablePath.ToReactivePropertyAsSynchronized(x => x.Path,
                ReactivePropertyMode.RaiseLatestValueOnSubscribe);

            if (validator != null)
            {
                filePathRp.SetValidateNotifyError(validator);
            }

            var isUseEnvVarRp = observablePath.ToReactivePropertyAsSynchronized(x => x.IsExpandEnvironmentVariable);

            var paramVm = paramVmFactory(filePathRp).AddTo(disposables);
            var compositeVm = new CompositeParamVm().AddTo(disposables);

            if (project.AppCapability.IsSupportEnvironmentVariableToPath)
            {
                var p = new CheckboxParamVm(
                    nameof(Resources.IsExpandEnvironmentVariable_Caption),
                    nameof(Resources.IsExpandEnvironmentVariable_Comment),
                    isUseEnvVarRp
                ).AddTo(disposables);
                p.IsReadOnly = paramVm.IsReadOnly;
                compositeVm.Params.AddOnScheduler(p);
            }

            paramVm.Additional = compositeVm;

            isUseEnvVarRp.Subscribe(_ => filePathRp.ForceValidate()).AddTo(disposables);

            return paramVm;
        }
    }
}
