﻿using Nintendo.Authoring.AuthoringEditor.Foundation;
using Reactive.Bindings;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class HexParamVm : ParamVm
    {
        public int DigitsOfChar { get; set; }
        public ulong Minimum { get; set; }
        public ulong Maximum { get; set; }

        public override string Comment => base.Comment == null ? null : string.Format(
            base.Comment,
            Minimum.ToUpperHexGrouping(),
            Maximum.ToUpperHexGrouping());

        public HexParamVm(string captionTag, string commentTag, IReactiveProperty property, int digitsOfChar,
            ulong minimum, ulong maximum)
            : base(captionTag, commentTag, property)
        {
            DigitsOfChar = digitsOfChar;
            Minimum = minimum;
            Maximum = maximum;
        }
    }
}
