﻿using System;
using System.IO;
using System.Reactive.Linq;
using BezelEditor.Foundation.Extentions;
using BezelEditor.Foundation.Utilities;
using Reactive.Bindings;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params
{
    public class DirPathStringParamVm : ParamVm, IFilePathPropertyParamVm
    {
        public ReactiveCommand<string> OpenByExplorerCommand { get; }

        public ReactiveProperty<string> FilePathProperty { get; }

        public DirPathStringParamVm(string captionTag, string commentTag, IReactiveProperty pathProperty,
            IObservable<string> absolutePathSource = null)
            : base(captionTag, commentTag, pathProperty)
        {
            FilePathProperty = (ReactiveProperty<string>)pathProperty;

            var path = string.Empty;

            OpenByExplorerCommand = (absolutePathSource ?? FilePathProperty)
                .Select(x =>
                {
                    path = x;
                    if (string.IsNullOrEmpty(FilePathProperty?.Value))
                        return false;
                    return Directory.Exists(x);
                })
                .ToReactiveCommand<string>()
                .AddTo(CompositeDisposable);

            OpenByExplorerCommand
                .Subscribe(_ => WindowsUtility.OpenFolderByExplorer(path))
                .AddTo(CompositeDisposable);
        }
    }

}
