﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------uj

using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class LocalCommunicationPageVm : PageVmBase
    {
        public LocalCommunicationPageVm(ApplicationMeta appMeta)
            : base(nameof(LocalCommunication))
        {
            var isReadOnlyRp = appMeta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            var comm = new ApplicationIdParamVm(
                nameof(LocalCommunicationId_Caption),
                nameof(LocalCommunicationId_Comment),
                nameof(AddLocalCommunicationId),
                appMeta.Application.LocalCommunicationIds,
                Core.Application.MaxLocalCommunicationIdCount,
                isReadOnlyRp
            ).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                comm
            };
        }
    }
}
