﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using System.Reactive.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class LimitationPageVm : PageVmBase
    {
        public EnumParamVm ParentalControl { get; }
        public RatingParamVm Rating { get; }
        public EnumParamVm RequiredNetworkServiceLicenseOnLaunch { get; }

        public LimitationPageVm(Project project, ApplicationMeta appMeta)
            : base(nameof(Limitation))
        {
            var isReadOnlyRp = appMeta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            ParentalControl = EnumParamVm.Factory(
                nameof(ParentalControl_Caption),
                nameof(ParentalControl_Comment),
                appMeta.Application.ToReactivePropertyAsSynchronized(x => x.ParentalControl)
            ).AddTo(CompositeDisposable);
            ParentalControl.IsReadOnly = isReadOnlyRp;

            /////////////////////////////////////////////////////////
            Rating = new RatingParamVm(
                nameof(Rating_Caption),
                nameof(Rating_Comment),
                appMeta.Application,
                isReadOnlyRp
            ).AddTo(CompositeDisposable);

            /////////////////////////////////////////////////////////
            if (project.AppCapability.IsSupportRequiredNetworkServiceLicenseOnLaunch &&
                appMeta.Application.RequiredNetworkServiceLicenseOnLaunch.HasValue)
            {
                RequiredNetworkServiceLicenseOnLaunch = EnumParamVm.Factory(
                    nameof(RequiredNetworkServiceLicenseOnLaunch_Caption),
                    nameof(RequiredNetworkServiceLicenseOnLaunch_Comment),
                    appMeta.Application.ToReactivePropertyAsSynchronized(x => x.RequiredNetworkServiceLicenseOnLaunch)
                ).AddTo(CompositeDisposable);
                RequiredNetworkServiceLicenseOnLaunch.IsReadOnly = isReadOnlyRp;
            }

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                ParentalControl,
                RequiredNetworkServiceLicenseOnLaunch,
                Rating
            }.Where(x => x != null).ToArray();

            /////////////////////////////////////////////////////////
            appMeta.Application.ObserveProperty(x => x.IsErrorRatings)
                .Where(_ => isReadOnlyRp.Value == false)
                .Subscribe(i => HasErrors.Value = i)
                .AddTo(CompositeDisposable);
        }
    }
}
