﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Linq;
using BezelEditor.Foundation.Extentions;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Nintendo.Authoring.AuthoringEditor.Properties;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class ApplicationPageVm : PageVmBase
    {
        public ApplicationPageVm(Project project)
            : base(nameof(Resources.Application))
        {
            var isPatchMode = project.PatchContentMeta != null;

            /////////////////////////////////////////////////////////
            var appHashDigestRp = project.PatchContentMeta != null ?
                project.PatchContentMeta.ToReactivePropertyAsSynchronized(x => x.Digest) :
                project.ApplicationContentMeta.ToReactivePropertyAsSynchronized(x => x.Digest);

            var appHashDigest = new StringParamVm(
                nameof(Resources.RomDigest_Caption),
                nameof(Resources.RomDigest_Comment),
                appHashDigestRp
            ).AddTo(CompositeDisposable);
            appHashDigest.Width = GuiConstants.SmallWidth;
            appHashDigest.IsReadOnly.Value = true;

            /////////////////////////////////////////////////////////
            var sdkVersionRp =
                project.ProgramInfo.ToReactivePropertyAsSynchronized(x => x.SdkVersion);

            var sdkVersion = new StringParamVm(
                nameof(Resources.SdkVersion_Caption),
                nameof(Resources.SdkVersion_Comment),
                sdkVersionRp
            ).AddTo(CompositeDisposable);
            sdkVersion.Width = GuiConstants.SmallWidth;
            sdkVersion.IsReadOnly.Value = true;

            /////////////////////////////////////////////////////////
            var toolVersionRp =
                project.ProgramInfo.ToReactivePropertyAsSynchronized(x => x.ToolVersion);

            var toolVersion = new StringParamVm(
                nameof(Resources.ToolVersion_Caption),
                nameof(Resources.ToolVersion_Comment),
                toolVersionRp
            ).AddTo(CompositeDisposable);
            toolVersion.Width = GuiConstants.SmallWidth;
            toolVersion.IsReadOnly.Value = true;

            /////////////////////////////////////////////////////////
            StringParamVm patchToolVersion = null;
            if (isPatchMode)
            {
                var patchToolVersionRp =
                    project.ProgramInfo.ToReactivePropertyAsSynchronized(x => x.PatchToolVersion);
                patchToolVersion = new StringParamVm(
                    nameof(Resources.PatchToolVersion_Caption),
                    nameof(Resources.PatchToolVersion_Comment),
                    patchToolVersionRp
                ).AddTo(CompositeDisposable);
                patchToolVersion.Width = GuiConstants.SmallWidth;
                patchToolVersion.IsReadOnly.Value = true;
            }

            /////////////////////////////////////////////////////////
            var buildTypeRp =
                project.ProgramInfo.ToReactivePropertyAsSynchronized(x => x.BuildType);

            var buildType = new StringParamVm(
                nameof(Resources.BuildType_Caption),
                nameof(Resources.BuildType_Comment),
                buildTypeRp
            ).AddTo(CompositeDisposable);
            buildType.Width = GuiConstants.SmallWidth;
            buildType.IsReadOnly.Value = true;

            /////////////////////////////////////////////////////////
            var middlewares = new MiddlewareParamVm(
                nameof(Resources.Middlewares_Caption),
                nameof(Resources.Middlewares_Comment),
                project.ProgramInfo.Middlewares
            ).AddTo(CompositeDisposable);
            middlewares.Width = GuiConstants.SmallWidth;
            middlewares.IsReadOnly.Value = true;

            /////////////////////////////////////////////////////////
            PatchHistoryParamVm history = null;
            if (isPatchMode)
            {
                history = new PatchHistoryParamVm(
                    nameof(Resources.PatchHistory_Caption),
                    nameof(Resources.PatchHistory_Comment),
                    project.PatchContentMeta.History);
                history.Width = GuiConstants.SmallWidth;
                history.IsReadOnly.Value = true;
            }

            /////////////////////////////////////////////////////////
            BoolOnOffParamVm patchDeltaUse = null;
            BoolOnOffParamVm patchDeltaUseBefrore3Nup = null;
            if (isPatchMode && project.PatchContentMeta.IsProduction)
            {
                var falseRp = new ReactiveProperty<bool>(false).AddTo(CompositeDisposable);
                var patchDeltaUseRp = new ReactiveProperty<bool>(project.PatchContentMeta.IsUsePatchDelta);
                patchDeltaUse = new BoolOnOffParamVm(
                    nameof(Resources.PatchDeltaUse_Caption),
                    nameof(Resources.PatchDeltaUse_Comment),
                    patchDeltaUseRp);
                patchDeltaUse.IsInputEnabled = falseRp;

                var patchDeltaUse3NupRp = new ReactiveProperty<bool>(project.PatchContentMeta.IsUsePatchDeltaBefore3NUP);
                patchDeltaUseBefrore3Nup = new BoolOnOffParamVm(
                    nameof(Resources.PatchDeltaUseBefore3Nup_Caption),
                    nameof(Resources.PatchDeltaUseBefore3Nup_Comment),
                    patchDeltaUse3NupRp);
                patchDeltaUseBefrore3Nup.IsInputEnabled = falseRp;
            }

            /////////////////////////////////////////////////////////
            Params = new ParamVm[]
            {
                appHashDigest,
                sdkVersion,
                toolVersion,
                patchToolVersion,
                buildType,
                middlewares,
                history,
                patchDeltaUse,
                patchDeltaUseBefrore3Nup
            }.Where(x => x != null).ToArray();
        }
    }
}
