﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Reactive.Bindings.Extensions;
using SimpleInjector;
using static Nintendo.Authoring.AuthoringEditor.Properties.Resources;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages
{
    public class AocOverviewPageVm : PageVmBase
    {
        public AocOverviewPageVm(Container diContainer, Project project)
            : base(nameof(AocOverview))
        {
            var isReadOnly = project.Meta.ToReactivePropertyAsSynchronized(x => x.IsReadOnly);

            var paramVms = new List<ParamVm>();

            /////////////////////////////////////////////////////////
            {
                var appIdRp =
                    project.AocMeta.ToReactivePropertyAsSynchronized(x => x.ApplicationId)
                        .SetValidateNotifyError(i => diContainer.GetInstance<PageValidations>().ApplicationId(i));

                var p = new HexParamVm(
                    nameof(ApplicationId_Caption),
                    nameof(ApplicationId_Comment),
                    appIdRp,
                    16,
                    Constants.ProgramIdMinimum,
                    Constants.ProgramIdMaximum
                ).AddTo(CompositeDisposable);
                p.IsReadOnly = isReadOnly;

                paramVms.Add(p);
            }

            /////////////////////////////////////////////////////////
            Params = paramVms.ToArray();
        }
    }
}
