﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reactive.Linq;
using BezelEditor.Foundation.Types;
using BezelEditor.Mvvm;
using Livet.Messaging;
using Nintendo.Authoring.AuthoringEditor.Core;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;

namespace Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Controls
{
    public class RunSaveDataSizeSimulatorVm : ViewModelBase
    {
        public string Caption => Properties.Resources.RunSaveDataSizeSimulator;

        public ReactiveCommand RunCommand { get; }

        public RunSaveDataSizeSimulatorVm(ApplicationMeta appMeta)
        {
            CultureService.Instance.ObserveProperty(x => x.Resources)
                .Subscribe(_ =>
                {
                    // ReSharper disable once ExplicitCallerInfoArgument
                    RaisePropertyChanged(nameof(Caption));
                }).AddTo(CompositeDisposable);

            RunCommand = new ReactiveCommand().AddTo(CompositeDisposable);
            RunCommand.Subscribe(_ => ShowSaveDataSizeSimulatorWindow(appMeta))
                .AddTo(CompositeDisposable);
        }

        private void ShowSaveDataSizeSimulatorWindow(ApplicationMeta appMeta)
        {
            using (var vm = new SaveDataSizeSimulatorWindowVm(appMeta))
            {
                Messenger.Raise(new TransitionMessage(vm, "ShowSaveDataSizeSimulatorWindow"));

                if (vm.DialogResult == DialogResultType.Ok)
                    appMeta.Application.SaveDataSize = vm.SaveDataSize;
            }
        }
    }
}
