﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace Nintendo.Authoring.AuthoringEditor.Controls
{
    public class CapacityEditBox : Control
    {
        #region DigitsOfChar

        public int DigitsOfChar
        {
            get { return (int) GetValue(DigitsOfCharProperty); }
            set { SetValue(DigitsOfCharProperty, value); }
        }

        public static readonly DependencyProperty DigitsOfCharProperty =
            DependencyProperty.Register(
                nameof(DigitsOfChar),
                typeof(int),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = 8,
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region Value

        public ulong Value
        {
            get { return (ulong) GetValue(ValueProperty); }
            set { SetValue(ValueProperty, value); }
        }

        public static readonly DependencyProperty ValueProperty =
            DependencyProperty.Register(
                nameof(Value),
                typeof(ulong),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(ulong),
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region Maximum

        public ulong Maximum
        {
            get { return (ulong) GetValue(MaximumProperty); }
            set { SetValue(MaximumProperty, value); }
        }

        public static readonly DependencyProperty MaximumProperty =
            DependencyProperty.Register(
                nameof(Maximum),
                typeof(ulong),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = ulong.MaxValue,
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region IsReadOnly

        public bool IsReadOnly
        {
            get { return (bool) GetValue(IsReadOnlyProperty); }
            set { SetValue(IsReadOnlyProperty, value); }
        }

        public static readonly DependencyProperty IsReadOnlyProperty =
            DependencyProperty.Register(
                nameof(IsReadOnly),
                typeof(bool),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(bool),
                    BindsTwoWayByDefault = true
                });

        #endregion

        #region CopyCommand

        public ICommand CopyCommand
        {
            get { return (ICommand)GetValue(CopyCommandProperty); }
            set { SetValue(CopyCommandProperty, value); }
        }

        public static readonly DependencyProperty CopyCommandProperty =
            DependencyProperty.Register(
                nameof(CopyCommand),
                typeof(ICommand),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(ICommand),
                    BindsTwoWayByDefault = false
                });

        #endregion

        #region Additional

        public Control Additional
        {
            get { return (Control)GetValue(AdditionalProperty); }
            set { SetValue(AdditionalProperty, value); }
        }

        public static readonly DependencyProperty AdditionalProperty =
            DependencyProperty.Register(
                nameof(Additional),
                typeof(Control),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(Control),
                    BindsTwoWayByDefault = false
                });

        #endregion

        public enum EditingStyles
        {
            Bytes,
            KiroBytes,
            MegaBytes,
            GigaBytes,
            BytesHex,
        }

        private static EditingStyles[] AllEditingStyles
            => Enum.GetValues(typeof(EditingStyles)).Cast<EditingStyles>().ToArray();

        #region EditingStyle

        public EditingStyles EditingStyle
        {
            get { return (EditingStyles) GetValue(EditingStyleProperty); }
            set { SetValue(EditingStyleProperty, value); }
        }

        public static readonly DependencyProperty EditingStyleProperty =
            DependencyProperty.Register(
                nameof(EditingStyle),
                typeof(EditingStyles),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = EditingStyles.KiroBytes,
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region IsVisibleStyleSelector

        public bool IsVisibleStyleSelector
        {
            get { return (bool) GetValue(IsVisibleStyleSelectorProperty); }
            set { SetValue(IsVisibleStyleSelectorProperty, value); }
        }

        public static readonly DependencyProperty IsVisibleStyleSelectorProperty =
            DependencyProperty.Register(
                nameof(IsVisibleStyleSelector),
                typeof(bool),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = true,
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region UnitCaption

        public string UnitCaption
        {
            get { return (string) GetValue(UnitCaptionProperty); }
            set { SetValue(UnitCaptionProperty, value); }
        }

        public static readonly DependencyProperty UnitCaptionProperty =
            DependencyProperty.Register(
                nameof(UnitCaption),
                typeof(string),
                typeof(CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = default(string),
                    BindsTwoWayByDefault = true
                }
            );

        #endregion

        #region EditingStyleCandidates

        public object EditingStyleCandidates
        {
            get { return GetValue(EditingStyleCandidatesProperty); }
            set { SetValue(EditingStyleCandidatesProperty, value); }
        }

        public static readonly DependencyProperty EditingStyleCandidatesProperty =
            DependencyProperty.Register(
                nameof (EditingStyleCandidates),
                typeof (object),
                typeof (CapacityEditBox),
                new FrameworkPropertyMetadata
                {
                    DefaultValue = AllEditingStyles,
                    BindsTwoWayByDefault = false
                }
            );

        #endregion

        static CapacityEditBox()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(CapacityEditBox),
                new FrameworkPropertyMetadata(typeof(CapacityEditBox)));
        }
    }
}
