﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Foundation.IO;

namespace Nintendo.Authoring.AuthoringEditor.Helper
{
    public class CompareCommandParams
    {
        [CommandLineOption("content-type", Description = "Compare the content type in nsp")]
        public ContentType ContentType { get; set; }

        [CommandLineOption("source", Description = "Compare the source nsp file", IsRequired = true)]
        public string SourceNspPath { get; set; }

        [CommandLineOption("source-nca", Description = "Compare the source nca file path in nsp")]
        public string SourceNcaFileName { get; set; }

        [CommandLineOption("target", Description = "Compare the target nsp file", IsRequired = true)]
        public string TargetNspPath { get; set; }

        [CommandLineOption("target-nca", Description = "Compare the target nca file path in nsp")]
        public string TargetNcaFileName { get; set; }

        [CommandLineOption("original", Description = "Compare the source application nsp file")]
        public string OriginalNspPath { get; set; }

        [CommandLineOption("nca-prefix-path", Description = "Compare the source/target nsp file path prefix")]
        public string NcaPrefixPath { get; set; }
    }

    public class ExtractCommandParams
    {
        [CommandLineValue(0, Description = "Extracting the nsp file", IsRequired = true)]
        public string NspPath { get; set; }

        [CommandLineOption("original", Description = "Extracting the source application nsp file (original)")]
        public string OriginalNspPath { get; set; }

        [CommandLineOption("target-list", Description = "Extracting file list")]
        public string ExtractFileListPath { get; set; }

        [CommandLineOption("target", Description = "Extracting file path (in nsp)")]
        public string ExtractTargetFile { get; set; }

        [CommandLineOption("content-type", Description = "Extract nca content type in nsp")]
        public ContentType ExtractContentType { get; set; }

        [CommandLineOption("output", Description = "Extract file output path")]
        public string OutputPath { get; set; }

        [CommandLineOption("output-dir", Description = "Extract file output directory path")]
        public string OutputDirectoryPath { get; set; }

        [CommandLineOption("standard-output", Description ="Extract file and direct output for stdout")]
        public bool IsStandardOutput { get; set; }

        [CommandLineOption("standard-output-encoding", Description = "Standard output encoding")]
        public string StandardOutputEncoding { get; set; }
    }

    public class CommandLineParams
    {
        [CommandLineSubCommand("compare", Description = "Compare the same NSP file")]
        public CompareCommandParams CompareOption { get; set; }

        [CommandLineSubCommand("extract", Description = "Extract files in the NSP")]
        public ExtractCommandParams ExtractOption { get; set; }
    }
}
