﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class JpegHelper
    {
        public static bool IsProgressive(byte[] image)
        {
            if (image.Length < 2)
                return false;

            if (image[0] != 0xFF || image[1] != 0xD8)
                return false;

            var ptr = 2;

            while (ptr < image.Length)
            {
                if (image[ptr++] != 0xFF)
                    break;

                var code = image[ptr++];

                if (code == 0xC2)
                    return true;

                if (code == 0xD9)
                    return false;

                var length = (image[ptr++] << 8) | image[ptr++];

                ptr += length - 2;
            }

            return false;
        }

        public static bool IsProgressive(string filePath)
        {
            var image = File.ReadAllBytes(filePath);

            return IsProgressive(image);
        }
    }
}
