﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using BezelEditor.Foundation.Extentions;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class CollectionExtensions
    {
        public static TSource Merge<TSource, TValue>(this TSource source, Collection<TValue> target,
            Func<TValue, TValue, bool> predicate, Action<TValue, TValue> replacer) where TSource : Collection<TValue>, new()
        {
            foreach (var x in target)
            {
                var isReplaced = false;
                foreach (var y in source)
                {
                    if (predicate(y, x))
                    {
                        replacer(y, x);
                        isReplaced = true;
                        break;
                    }
                }
                if (!isReplaced)
                    source.Add(x);
            }
            return source;
        }

        public static TSource Replace<TSource, TValue>(this TSource source, Collection<TValue> target,
            Func<TValue, TValue, bool> predicate, Action<TValue, TValue> replacer) where TSource : Collection<TValue>
        {
            var addToSourceItems = new Collection<TValue>();
            var replacedItems = new HashSet<TValue>();
            foreach (var x in target)
            {
                var isReplaced = false;
                foreach (var y in source)
                {
                    if (predicate(y, x))
                    {
                        replacer(y, x);
                        replacedItems.Add(y);
                        isReplaced = true;
                        break;
                    }
                }
                if (!isReplaced)
                    addToSourceItems.Add(x);
            }

            {
                var moreveToSourceItems = source.Where(x => !replacedItems.Contains(x)).ToArray();
                moreveToSourceItems.RemoveRangeTo(source);
            }
            addToSourceItems.AddRangeTo(source);

            return source;
        }
    }
}
