﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace Nintendo.Authoring.AuthoringEditor.Foundation
{
    public static class AuthoringToolHelper
    {
        public static string AuthoringToolExe
        {
            get
            {
                var paths = new List<string>();

                if (ExecutingAssemblyDirectoryPath != null)
                    paths.Add(Path.Combine(ExecutingAssemblyDirectoryPath, @"AuthoringTool\AuthoringTool.exe"));

                if (NintendoSdkRoot != null)
                    paths.Add(Path.Combine(NintendoSdkRoot, @"Tools\CommandLineTools\AuthoringTool\AuthoringTool.exe"));

                paths.Add(Environment.ExpandEnvironmentVariables(@"%NINTENDO_SDK_ROOT%\Tools\CommandLineTools\AuthoringTool\AuthoringTool.exe") );

                return paths.FirstOrDefault(File.Exists);
            }
        }

        public static string AuthoringEditorHelperExe
        {
            get
            {
                var paths = new List<string>();

                if (ExecutingAssemblyDirectoryPath != null)
                    paths.Add(Path.Combine(ExecutingAssemblyDirectoryPath, @"AuthoringEditor.Helper.exe"));

                if (NintendoSdkRoot != null)
                    paths.Add(Path.Combine(NintendoSdkRoot, @"Tools\AuthoringEditor\AuthoringEditor.Helper.exe"));

                paths.Add(Environment.ExpandEnvironmentVariables(@"%NINTENDO_SDK_ROOT%\Tools\AuthoringEditor\AuthoringEditor.Helper.exe"));

                return paths.FirstOrDefault(File.Exists);
            }
        }

        private static string NintendoSdkRoot
        {
            get
            {
                var directoryPath = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;

                while (!string.IsNullOrEmpty(directoryPath))
                {
                    if (File.Exists(Path.Combine(directoryPath, "NintendoSdkRootMark")))
                        return directoryPath;

                    directoryPath = Path.GetDirectoryName(directoryPath);
                }

                return null;
            }
        }

        private static string ExecutingAssemblyDirectoryPath
        {
            get
            {
                var executingAsm = System.Reflection.Assembly.GetExecutingAssembly();

                return  Path.GetDirectoryName(executingAsm.Location);
            }
        }
    }
}
