﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace SpatialAudioEvaluationTool
{
    namespace Win32
    {
        using DWORD = System.UInt32;
        using UINT = System.UInt32;
        using HWND = IntPtr;
        using BOOL = System.Int32;
        public class Win32Window
        {
            [DllImport("user32.dll")]
            static public extern BOOL FlashWindowEx(ref FLASHWINFO pwfi);

            static public HWND GetWindowHandle()
            {
                Process currentProcess = Process.GetCurrentProcess();
                if (currentProcess.MainWindowHandle != HWND.Zero)
                {
                    return currentProcess.MainWindowHandle;
                }

                return HWND.Zero;
            }

            [StructLayout(LayoutKind.Sequential)]
            public struct FLASHWINFO
            {
                public UINT cbSize;
                public HWND hwnd;
                public DWORD dwFlags;
                public UINT uCount;
                public DWORD dwTimeOut;
            }

            static public DWORD FLASHW_STOP = 0x00000000;
            static public DWORD FLASHW_CAPTION = 0x00000001;
            static public DWORD FLASHW_TRAY = 0x00000002;
            static public DWORD FLASHW_ALL = 0x00000003;
            static public DWORD FLASHW_TIMER = 0x00000004;
            static public DWORD FLASHW_TIMERNOFG = 0x0000000C;
        }
    }
}
