﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Globalization;
using System.Windows.Data;

namespace SpatialAudioEvaluationTool.Converter
{
    public class RecordingStateToTextConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is RecordingState))
            {
                throw new ArgumentException();
            }
            switch ((RecordingState)value)
            {
                case RecordingState.NoConnection:
                    return Resources.RecordingStateMessages.NoConnection;
                case RecordingState.Connecting:
                    return Resources.RecordingStateMessages.Connecting;
                case RecordingState.Connected:
                    return Resources.RecordingStateMessages.Connected;
                case RecordingState.Recording:
                    return Resources.RecordingStateMessages.Recording;
                case RecordingState.Stopping:
                    return Resources.RecordingStateMessages.Stopping;
                default:
                    throw new ArgumentOutOfRangeException();
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
