﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdarg>
#include <nn/nn_Common.h>

#if ! defined(NN_DEVMENUSYSTEM) || defined(NN_DEVMENULOTCHECK_DOWNLOADER)
#include <nn/nn_Log.h>

#define DEVMENUCOMMAND_LOG(...) NN_LOG(__VA_ARGS__)
#define DEVMENUCOMMAND_VLOG(format, vaList) NN_VLOG(format, vaList)

#else

namespace devmenu{

typedef void (*LogCallback)(const char* format, ...);
typedef void (*VLogCallback)(const char* format, std::va_list vaList);

void RegisterLogCallback(LogCallback f) NN_NOEXCEPT;
LogCallback GetLogCallback() NN_NOEXCEPT;

void RegisterVLogCallback(VLogCallback f) NN_NOEXCEPT;
VLogCallback GetVLogCallback() NN_NOEXCEPT;

}

#define DEVMENUCOMMAND_LOG(...) devmenu::GetLogCallback()(__VA_ARGS__)
#define DEVMENUCOMMAND_VLOG(format, vaList) devmenu::GetVLogCallback()(format, vaList)


#endif

#if defined(NN_TOOL_DEVMENUCOMMANDSYSTEM)
#define DEVMENUCOMMANDSYSTEM_LOG(...) DEVMENUCOMMAND_LOG(__VA_ARGS__)
#else
#define DEVMENUCOMMANDSYSTEM_LOG(...)                                     \
    do                                                                  \
    {                                                                   \
    } while (NN_STATIC_CONDITION(0))
#endif
