﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include "DevMenuCommand_HttpConnection.h"

using namespace nn;

HttpConnection::~HttpConnection() NN_NOEXCEPT
{
    nim::srv::HttpConnection::Finalize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_SslContext.Destroy());
}

Result HttpConnection::Initialize() NN_NOEXCEPT
{
    NN_RESULT_DO(m_SslContext.Create(ssl::Context::SslVersion_Auto));
    ssl::CertStoreId certStoreId;
    NN_RESULT_DO(m_SslContext.RegisterInternalPki(&certStoreId, ssl::Context::InternalPki_DeviceClientCertDefault));
    NN_RESULT_DO(nim::srv::HttpConnection::Initialize(&m_SslContext));
    NN_RESULT_SUCCESS;
}
