﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentInfoData.h>

namespace devmenuUtil
{

nn::Result GetApplicationRomIdHash(nn::ncm::Hash* outHash, const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId = nn::ncm::StorageId::Any) NN_NOEXCEPT;

nn::Result VerifyApplicationAndPatchCombination(const nn::ncm::ApplicationId& id, nn::ncm::StorageId appStorage = nn::ncm::StorageId::Any, nn::ncm::StorageId patchStorage = nn::ncm::StorageId::Any) NN_NOEXCEPT;

}
