﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/err/err_ReportErrorApi.h>

#include "DevMenuCommand_Common.h"

namespace devmenuUtil {

template <class AsyncT>
void ReportErrorContext(AsyncT* async, nn::Result result)
{
// 現状の DevMenu には ReportError() の実行権限が無いので無効化する
#if !defined(NN_DEVMENU)
    nn::err::ErrorContext context;
    async->GetErrorContext(&context);

    std::unique_ptr<char[]> buffer(new char[1024]);
    if( !buffer )
    {
        NN_LOG("Failed to allocate work buffer to report error.\n");
        return;
    }
    nn::err::ReportError(devmenuUtil::GetSelfApplicationId(), result, context, buffer.get(), 1024);
#else
    NN_UNUSED(async);
    NN_UNUSED(result);
#endif
}

template <class AsyncT>
nn::Result Get(AsyncT* async)
{
    auto result = async->Get();
    if (result.IsFailure())
    {
        ReportErrorContext(async, result);
    }
    return result;
}

template <class ValueListT, class AsyncT>
nn::Result Get(int* outCount, ValueListT* outList, int listCount, AsyncT* async)
{
    auto result = async->Get(outCount, outList, listCount);
    if (result.IsFailure())
    {
        ReportErrorContext(async, result);
    }
    return result;
}

template <class ValueT, class AsyncT>
nn::Result Get(ValueT* outValue, AsyncT* async)
{
    auto result = async->Get(outValue);
    if (result.IsFailure())
    {
        ReportErrorContext(async, result);
    }
    return result;
}
}
