﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/es/es_ELicenseTypesForInner.h>
#include <nn/nim/nim_DynamicRightsTypes.h>

#include "DevMenuCommand_Json.h"
#include "DevMenuCommand_Option.h"

namespace devmenuUtil {

    constexpr int RightsIdsMax   = 256;
    constexpr int ELicenseIdsMax = 256;

    const char* GetStringFrom(const nn::nim::ELicenseType& v) NN_NOEXCEPT;
    const char* GetStringFrom(const nn::nim::ELicenseStatus& v) NN_NOEXCEPT;
    const char* GetStringFrom(const nn::nim::RevokeReason& v) NN_NOEXCEPT;
    const char* GetStringFrom(const nn::es::ELicenseScope& v) NN_NOEXCEPT;

    void PrintAvailableELicense(const nn::nim::AvailableELicense& l) NN_NOEXCEPT;
    void PrintAssignedELicense(const nn::nim::AssignedELicense& l) NN_NOEXCEPT;
    void PrintELicenseInfoWrapper(const nn::es::ELicenseInfoWrapper& e) NN_NOEXCEPT;
    void PrintELicenseInfoForSystemWrapper(const nn::es::ELicenseInfoForSystemWrapper& e) NN_NOEXCEPT;

    nn::Result GetRightsIdsFromTarget(int* outCount, nn::es::RightsId* outValues, int maxCount, const Option& option) NN_NOEXCEPT;
    nn::Result GetELicenseIdsFromTarget(int* outCount, nn::es::ELicenseId* outValues, int maxCount, const Option& option) NN_NOEXCEPT;
    nn::Result GetUidFromOption(nn::account::Uid* outValue, const Option& option) NN_NOEXCEPT;
    nn::Result GetELicenseTypeFromOption(nn::util::optional<nn::nim::ELicenseType>* outValue, const Option& option) NN_NOEXCEPT;
    nn::Result GetELicenseStatusFromOption(nn::util::optional<nn::nim::ELicenseStatus>* outValue, const Option& option) NN_NOEXCEPT;
    nn::Result GetNintendoAccountId(nn::account::NintendoAccountId* outValue, const nn::account::Uid& uid);
    nn::Result GetTimeSpanFromOption(nn::util::optional<nn::TimeSpan>* outValue, const Option& option, const char* key) NN_NOEXCEPT;

    bool GetByCurl(RAPIDJSON_NAMESPACE::Document* responseBody, const nn::account::NintendoAccountId& naId, const char* path) NN_NOEXCEPT;
    bool PostByCurl(RAPIDJSON_NAMESPACE::Document* responseBody, const nn::account::NintendoAccountId& naId, const char* path, RAPIDJSON_NAMESPACE::Document& requestBody) NN_NOEXCEPT;
}

