﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "CalWriter_IFile.h"
#include <nn/nn_Abort.h>
#include <nn/util/util_BitUtil.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/fs_Base.h>
#include <memory>

#include <nn/manu/manu_Api.h>

class ManuFile : public IFile
{
public:
    ManuFile() : m_Path(nullptr) {}
    virtual ~ManuFile() {}

    virtual nn::Result OpenRead(const char *path);
    virtual nn::Result OpenWrite(const char *path);
    virtual void Close();
    virtual nn::Result Write(int64_t offset, const void* buffer, size_t size, bool flush);
    virtual nn::Result Read(size_t* pOut, int64_t offset, void* buffer, size_t size);
    virtual nn::Result GetSize(int64_t* pOut);
    virtual nn::Result Flush();
    virtual bool IsValid();
    static nn::Result Exists(bool *pOut, const char *path);
    static nn::Result Create(const char *path);
private:
    const char *m_Path;
};

nn::Result OpenManuFile(std::shared_ptr<IFile> *pOut, const char *path, int mode)
{
    *pOut = std::shared_ptr<IFile>(new ManuFile());

    (*pOut)->OpenWrite(path);

    NN_RESULT_SUCCESS;
}

nn::Result ManuFile::OpenRead(const char *path)
{
    m_Path = path;

    NN_RESULT_SUCCESS;
}

nn::Result ManuFile::OpenWrite(const char *path)
{
    m_Path = path;

    NN_RESULT_SUCCESS;
}

void ManuFile::Close()
{
    m_Path = nullptr;
}

nn::Result ManuFile::Write(int64_t offset, const void* buffer, size_t size, bool flush)
{
    NN_RESULT_DO(
        nn::manu::WriteToHost(buffer, static_cast<size_t>(size), m_Path, offset, size));

    NN_RESULT_SUCCESS;
}

nn::Result ManuFile::Read(size_t* pOut, int64_t offset, void* buffer, size_t size)
{
    NN_RESULT_DO(
        nn::manu::ReadFromHost(buffer, size, m_Path, offset, size));
    *pOut = size;

    NN_RESULT_SUCCESS;
}

nn::Result ManuFile::GetSize(int64_t* pOut)
{
    size_t outSize;
    NN_RESULT_DO(
        nn::manu::GetFileSize(&outSize, m_Path));

    *pOut = static_cast<int64_t>(outSize);

    NN_RESULT_SUCCESS;
}

nn::Result ManuFile::Flush()
{
    NN_RESULT_SUCCESS;
}


bool ManuFile::IsValid()
{
    return m_Path != nullptr;
}

nn::Result ManuFile::Exists(bool *pOut, const char *name)
{
    size_t outSize;
    nn::Result result = nn::manu::GetFileSize(&outSize, name);
    *pOut = result.IsSuccess();

    NN_RESULT_SUCCESS;
}

nn::Result ManuFile::Create(const char *path)
{
    uint8_t buffer[8];
    NN_RESULT_DO(
        nn::manu::WriteToHost(buffer, 0, path, 0, 0));

    NN_RESULT_SUCCESS;
}
