﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>

#include "CalWriter_Crc16.h"

namespace {

//!< CRC-16 計算時の初期値
const uint16_t Crc16InitialValue = 0x55aa;

//!< CRC-16 テーブル
const uint16_t Crc16Table[16] = {
    0x0000, 0xcc01, 0xd801, 0x1400,
    0xf001, 0x3c00, 0x2800, 0xe401,
    0xa001, 0x6c00, 0x7800, 0xb401,
    0x5000, 0x9c01, 0x8801, 0x4400
};

} // namespace

uint16_t GetCrc16(const void* addr, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(addr);
    auto data = reinterpret_cast<const ::nn::Bit8*>(addr);
    uint16_t crc = Crc16InitialValue;
    uint16_t r1;
    while (size-- > 0)
    {
        r1 = Crc16Table[crc & 0xf];
        crc = (crc >> 4) & 0x0fff;
        crc = crc ^ r1 ^ Crc16Table[*data & 0xf];
        r1 = Crc16Table[crc & 0xf];
        crc = (crc >> 4) & 0x0fff;
        crc = crc ^ r1 ^ Crc16Table[(*data >> 4) & 0xf];
        data++;
    }
    return crc;
}
