﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>
#include <nn/os/os_SharedMemory.h>

#include "wlan_ApiImplBase.h"
#include "../wlan_StateMachine.h"
#include "../wlan_DebugLog.h"
#include "../../../Libraries/wlan/detail/wlan_IWlanManagers.sfdl.h"

#include <nn/wlan/wlan_Cbuf.h>

namespace nn { namespace wlan{ namespace server
{

    class SocketApiImpl : public ApiImplBase
    {
    private:
        static void RxThreadEntry(void* arg)
        NN_NOEXCEPT
        {
            SocketApiImpl* p = (SocketApiImpl*)arg;
            p->ReceiveThread();
        }

        static void TxThreadEntry(void* arg)
        NN_NOEXCEPT
        {
            SocketApiImpl* p = (SocketApiImpl*)arg;
            p->SendThread();
        }

    public:
        explicit SocketApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("SocketApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~SocketApiImpl() NN_NOEXCEPT {}
        nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result SwitchTsfTimerFunction(bool enable) NN_NOEXCEPT;
        nn::Result GetDeltaTimeBetweenSystemAndTsf(nn::sf::Out<std::int64_t> pOutDeltaTime) NN_NOEXCEPT;
        nn::Result RegisterSharedMemory(nn::sf::NativeHandle memHandle,uint32_t memSize,
                                        nn::sf::NativeHandle RxEventHandle, nn::sf::NativeHandle TxEventHandle,
                                        nn::sf::NativeHandle RxCbufEventHandle, nn::sf::NativeHandle TxCbufEventHandle) NN_NOEXCEPT;
        nn::Result UnregisterSharedMemory() NN_NOEXCEPT;
        nn::Result EnableSharedMemory() NN_NOEXCEPT;
        void ReceiveThread() NN_NOEXCEPT;
        void SendThread()    NN_NOEXCEPT;
        nn::Result SetMulticastFilter(const nn::wlan::detail::SfdlMulticastFilterInfo& sfdlInfo) NN_NOEXCEPT;

    }; // end of class SocketApiImpl

    class SocketGetFrameApiImpl
    {
    private:
        // WLANプロセスで走るステートマシーンの実体を受け取るためのポインタ
        nn::wlan::StateMachine* m_pStateMachine;

    public:
        explicit SocketGetFrameApiImpl(nn::wlan::StateMachine* pStateMachine) NN_NOEXCEPT
        {
            WLAN_LOG_DEBUG("SocketGetFrameApiImpl constructor called\n");
            NN_SDK_ASSERT_NOT_NULL(pStateMachine);
            m_pStateMachine = pStateMachine;
        }
        ~SocketGetFrameApiImpl() NN_NOEXCEPT {}

        nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT;

    };

}}} // end of namespace nn::wlan::server

