﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/diag/diag_LogObserver.h>

namespace nn { namespace wlan { namespace dbg {

void wlan_DbgConsoleInit() NN_NOEXCEPT;

class wlanDbgConsole : public nn::wlan::dbg::WlanHtcs
{
public:
    wlanDbgConsole();
    ~wlanDbgConsole();

    void InputCallBack(char* buff, int length) NN_NOEXCEPT;
    void TerminateCallback() NN_NOEXCEPT;

private:
    static void LogObserver(const nn::diag::LogMetaData& metaInfo, const nn::diag::LogBody& logBody, void* argument);
};

}}}

